/**************************************************************************//**
 * @file main_cmu_hfxo_autostart.h
 * @brief CMU automatic HFXO start example for  EFR32/EFM32 Series 1
 * @version  1.13

 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2017 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/

#ifndef MAIN_CMU_HFXO_AUTOSTART_H
#define MAIN_CMU_HFXO_AUTOSTART_H

#include "em_device.h"
#include "em_chip.h"
#include "em_cmu.h"
#include "em_emu.h"
#include "em_gpio.h"
#include "em_letimer.h"
#include "em_usart.h"
#include "display.h"
#include "textdisplay.h"
#include "retargettextdisplay.h"

#include <stdio.h>

#define USE_LFTIMEOUT                   1
#define USE_AUTO_HFXO                   1

#define WAKEUP_INTERVAL_MS    1000
#define COUNT_BETWEEN_WAKEUP  (((32768 * WAKEUP_INTERVAL_MS) / 1000) - 1)

#if defined(_EFM32_PEARL_FAMILY) && defined(EFM32PG1B200F256GM48)
// Configuration for Pearl Gecko STKs
#define LETIMER_OUTPUT_PORT   gpioPortA
#define LETIMER_OUTPUT_PIN    0           // expansion header pin 12
#define LETIMER_ROUTE_MASK    _LETIMER_ROUTELOC0_OUT0LOC_MASK
#define LETIMER_ROUTE_LOCN    LETIMER_ROUTELOC0_OUT0LOC_LOC0
#define EXP_LETIMER_OUT       12

#define GPIO_INPUT_PORT       gpioPortA
#define GPIO_INPUT_PIN        3           // expansion header pin 5
#define EXP_GPIO_IN           5

#define GPIO_INT_TOGGLE_PORT  gpioPortA
#define GPIO_INT_TOGGLE_PIN   1           // expansion header pin 14
#define EXP_GPIO_OUT          14

#define CMU_INT_TOGGLE_PORT   gpioPortA
#define CMU_INT_TOGGLE_PIN    2           // expansion header pin 3
#define EXP_CMU_INT           3

#define CMU_CLK_PORT          gpioPortC
#define CMU_CLK_PIN           11           // expansion header pin 15
#define CMU_ROUTE_LOCN        CMU_ROUTELOC0_CLKOUT0LOC_LOC3
#define EXP_CMU_CLK           15
#elif defined(_EFM32_PEARL_FAMILY) && defined(EFM32PG12B500F1024GL125)
#define LETIMER_OUTPUT_PORT   gpioPortD
#define LETIMER_OUTPUT_PIN    10          // expansion header pin 12
#define LETIMER_ROUTE_MASK    _LETIMER_ROUTELOC0_OUT0LOC_MASK
#define LETIMER_ROUTE_LOCN    LETIMER_ROUTELOC0_OUT0LOC_LOC18
#define EXP_LETIMER_OUT       12

#define GPIO_INPUT_PORT       gpioPortD
#define GPIO_INPUT_PIN        9           // expansion header pin 5
#define EXP_GPIO_IN           5

#define GPIO_INT_TOGGLE_PORT  gpioPortD
#define GPIO_INT_TOGGLE_PIN   11          // expansion header pin 14
#define EXP_GPIO_OUT          14

#define CMU_INT_TOGGLE_PORT   gpioPortC
#define CMU_INT_TOGGLE_PIN    9           // expansion header pin 3
#define EXP_CMU_INT           3

#define CMU_CLK_PORT          gpioPortC
#define CMU_CLK_PIN           11           // expansion header pin 15
#define CMU_ROUTE_LOCN        CMU_ROUTELOC0_CLKOUT0LOC_LOC3
#define EXP_CMU_CLK           15
#elif (defined (_EFR32_BLUE_FAMILY) || defined(_EFR32_FLEX_FAMILY) || defined(_EFR32_MIGHTY_FAMILY)) && \
      (defined(EFR32MG12P332F1024GL125) || defined(EFR32MG12P432F1024GL125) || \
       defined(EFR32MG12P433F1024GL125) || defined(EFR32FG12P433F1024GL125) || \
       defined(EFR32BG12P332F1024GL125))
// Clock output pin on Mighty Gecko WSTKs
#define LETIMER_OUTPUT_PORT   gpioPortD
#define LETIMER_OUTPUT_PIN    9           // expansion header pin 5
#define LETIMER_ROUTE_MASK    _LETIMER_ROUTELOC0_OUT0LOC_MASK
#define LETIMER_ROUTE_LOCN    LETIMER_ROUTELOC0_OUT0LOC_LOC17
#define EXP_LETIMER_OUT       5

#define GPIO_INPUT_PORT       gpioPortA
#define GPIO_INPUT_PIN        7           // expansion header pin 6
#define EXP_GPIO_IN           6

#define GPIO_INT_TOGGLE_PORT  gpioPortA
#define GPIO_INT_TOGGLE_PIN   6           // expansion header pin 4
#define EXP_GPIO_OUT          4

#define CMU_INT_TOGGLE_PORT   gpioPortA
#define CMU_INT_TOGGLE_PIN    8           // expansion header pin 8
#define EXP_CMU_INT           8

#define CMU_CLK_PORT          gpioPortC
#define CMU_CLK_PIN           11           // expansion header pin 16
#define CMU_ROUTE_LOCN        CMU_ROUTELOC0_CLKOUT0LOC_LOC3
#define EXP_CMU_CLK           16
#elif (defined (_EFR32_BLUE_FAMILY) || defined (_EFR32_FLEX_FAMILY) || defined (_EFR32_MIGHTY_FAMILY)) && \
      (defined(EFR32BG1P232F256GM48) || defined(EFR32BG1B232F256GM48) || \
       defined(EFR32FG1P133F256GM48) || defined(EFR32MG1P232F256GM48) || \
       defined(EFR32MG1P132F256GM48) || defined(EFR32MG13P733F512GM48))
// Clock output pin on Mighty Gecko WSTKs
#define LETIMER_OUTPUT_PORT   gpioPortA
#define LETIMER_OUTPUT_PIN    3           // expansion header pin 5
#define LETIMER_ROUTE_MASK    _LETIMER_ROUTELOC0_OUT0LOC_MASK
#define LETIMER_ROUTE_LOCN    LETIMER_ROUTELOC0_OUT0LOC_LOC3
#define EXP_LETIMER_OUT       5

#define GPIO_INPUT_PORT       gpioPortC
#define GPIO_INPUT_PIN        7           // expansion header pin 6
#define EXP_GPIO_IN           6

#define GPIO_INT_TOGGLE_PORT  gpioPortC
#define GPIO_INT_TOGGLE_PIN   6           // expansion header pin 4
#define EXP_GPIO_OUT          4

#define CMU_INT_TOGGLE_PORT   gpioPortC
#define CMU_INT_TOGGLE_PIN    8           // expansion header pin 8
#define EXP_CMU_INT           8

#define CMU_CLK_PORT          gpioPortC
#define CMU_CLK_PIN           11           // expansion header pin 16
#define CMU_ROUTE_LOCN        CMU_ROUTELOC0_CLKOUT0LOC_LOC3
#define EXP_CMU_CLK           16
#elif defined(_EFM32_GIANT_FAMILY) && defined(_SILICON_LABS_32B_SERIES_1)
#define LETIMER_OUTPUT_PORT   gpioPortE
#define LETIMER_OUTPUT_PIN    12           // expansion header pin 8
#define LETIMER_ROUTE_MASK    _LETIMER_ROUTELOC0_OUT0LOC_MASK
#define LETIMER_ROUTE_LOCN    LETIMER_ROUTELOC0_OUT0LOC_LOC4
#define EXP_LETIMER_OUT       8

#define GPIO_INT_TOGGLE_PORT  gpioPortE
#define GPIO_INT_TOGGLE_PIN   11           // expansion header pin 6
#define EXP_GPIO_OUT          6

#define GPIO_INPUT_PORT       gpioPortE
#define GPIO_INPUT_PIN        13           // expansion header pin 10
#define EXP_GPIO_IN           10

#define CMU_INT_TOGGLE_PORT   gpioPortE
#define CMU_INT_TOGGLE_PIN    10           // expansion header pin 4
#define EXP_CMU_INT           4

#define CMU_CLK_PORT          gpioPortA
#define CMU_CLK_PIN           12           // expansion header pin 3
#define CMU_ROUTE_LOCN        CMU_ROUTELOC0_CLKOUT0LOC_LOC5
#define EXP_CMU_CLK           3
#else
#error "Device not supported by this code example."
#endif

#endif /* MAIN_CMU_HFXO_AUTOSTART_H */
