/**************************************************************************//**
 * @file main_cmu_example.h
 * @brief CMU Examples for EFM32 Gecko Series 0 and 1
 * @version  1.11

 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2017 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/

#ifndef MAIN_CMU_EXAMPLE_H
#define MAIN_CMU_EXAMPLE_H

#include "em_chip.h"
#include "em_cmu.h"
#include "em_device.h"
#include "em_emu.h"
#include "em_gpio.h"
//#include "graphics.h"
#include "retargetserial.h"
#include "expconfig.h"
#include <stdio.h>

/* Push buttons and CMU outputs used on EFR32 WSTK/Radio Boards */
#include "bspconfig.h"
#define EXIT_BUTTON             "Press PB1 to exit\r\n\r\n"
#define NEXT_BUTTON             "Press PB1 for next "
#define RUN_BUTTON              "Press PB0 to start\r\n"
#define CMU_OUT1_PORT           BSP_EXP_HEADER4_PORT       /* CMU_OUT1 for all RC osc */
#define CMU_OUT1_PIN            BSP_EXP_HEADER4_PIN
#define CMU_OUT_PEN             GPIO_CMU_ROUTEEN_CLKOUT1PEN
#define CMU_LFRCO_SELECT        CMU_CTRL_CLKOUTSEL1_LFRCO         
#define CMU_HFRCODPLL_SELECT    CMU_CTRL_CLKOUTSEL1_HFRCODPLL
#define CMU_HFRCOEM23_SELECT    CMU_CTRL_CLKOUTSEL1_HFRCOEM23  

// must remap GPIO to pins on port A/B for interrupts to work in EM2/3
#define  PB0_REMAP_PORT  gpioPortA
#define  PB0_REMAP_PIN   0

#define  PB1_REMAP_PORT  gpioPortA
#define  PB1_REMAP_PIN   3

#define CMU_OUT_EN            1
#if CMU_OUT_EN == 1
/* Configure the CMU to output RC oscillator on CMU_OUT0 or CMU_OUT1 pin */
#if !defined(_PRS_CH_CTRL_SOURCESEL_CMU)
#define CMU_OUT_CLR             CMU->EXPORTCLKCTRL &= ~(_CMU_EXPORTCLKCTRL_CLKOUTSEL0_MASK + _CMU_EXPORTCLKCTRL_CLKOUTSEL1_MASK)
#else
/* Keep ULFRCOQ as CLKOUTSEL0 source for PRS to toggle GPIO */
#define CMU_OUT_CLR             CMU->EXPORTCLKCTRL &= ~(_CMU_EXPORTCLKCTRL_CLKOUTSEL1_MASK)
#endif
#define CMU_OUT_LFRCO           CMU->EXPORTCLKCTRL |= CMU_EXPORTCLKCTRL_CLKOUTSEL1_LFRCO         
#define CMU_OUT_HFRCODPLL       CMU->EXPORTCLKCTRL |= CMU_EXPORTCLKCTRL_CLKOUTSEL1_HFRCODPLL
#define CMU_OUT_HFRCOEM23       CMU->EXPORTCLKCTRL |= CMU_EXPORTCLKCTRL_CLKOUTSEL1_HFRCOEM23
#else
/* Do nothing if CMU_OUT_EN == 0 */
#define CMU_OUT_CLR            
#define CMU_OUT_LFRCO          
#define CMU_OUT_HFRCODPLL
#define CMU_OUT_HFRCOEM23
#endif

/* TOP value for down counter, maximum value is 2^20-1 = 0xFFFFF */
/* Higher value for higher calibration accuracy but longer time */
#define DOWN_TOP_VALUE          0xFFFFF

/* RC oscillator band and frequency for tuning */
#define LFRCO_TUNE_FREQ          32768
#define HFRCODPLL_TUNE_BAND      cmuHFRCODPLLFreq_19M0Hz
#define HFRCODPLL_TUNE_FREQ      19000000
#define HFRCOEM23_TUNE_BAND      cmuHFRCOEM23Freq_19M0Hz
#define HFRCOEM23_TUNE_FREQ      19000000

#if defined(_SILICON_LABS_32B_SERIES_2_CONFIG_1)
/* Menu items for EFR32xG21 */
#define LFRCO_CAL               0
#define HFRCODPLL_CAL           1
#define HFRCOEM23_CAL           2
#define MENU_MAX                3
#define MENU_START				0

/* CMU interrupt flag declarations for EFR32xG21 */
#define CMU_IF_CALRDY_DEF	CMU_IF_CALRDY
#else
/* Menu items for EFR32xG22 */
#define HFRCODPLL_CAL           0
#define MENU_MAX                1
#define MENU_START				0

/* CMU interrupt flag declarations for EFR32xG22 */
#define CMU_IF_CALRDY_DEF	CMU_IF_CALRDYIF
#endif

/* Functions prototype */
void gpioSetup(void);
void printMenu(void);
bool endOfTune(void);
uint32_t getUpcount(bool targetCnt);
void calibrateRcOsc(CMU_Osc_TypeDef rcOsc, uint32_t rcOscFreq, bool calCont, bool fineEnable);
uint32_t CMU_OscillatorFineTuningGet(CMU_Osc_TypeDef osc);

#endif /* MAIN_CMU_EXAMPLE_H */
