/**************************************************************************//**
 * @file main_cmu_hfxo_on_demand.h
 * @brief CMU on-demand HFXO start example for  EFR32 Series 2
 * @version  1.11

 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2017 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/

#ifndef MAIN_CMU_HFXO_AUTOSTART_H
#define MAIN_CMU_HFXO_AUTOSTART_H

#include "em_device.h"
#include "em_chip.h"
#include "em_cmu.h"
#include "em_emu.h"
#include "em_gpio.h"
#include "em_letimer.h"
#include "em_usart.h"
#include "retargetserial.h"
#include "expconfig.h"
#include <stdio.h>

#define USE_LFTIMEOUT                   1
#define USE_AUTO_HFXO                   1

#define WAKEUP_INTERVAL_MS    1000
#define COUNT_BETWEEN_WAKEUP  (((32768 * WAKEUP_INTERVAL_MS) / 1000) - 1)

#define LETIMER_OUTPUT_PORT   BSP_EXP_HEADER4_PORT//gpioPortC
#define LETIMER_OUTPUT_PIN    BSP_EXP_HEADER4_PIN//0           // expansion header pin 4, also DISP_MOSI
#define EXP_LETIMER_OUT       4

/* Because only pins in ports A and B will wake the device from EM2
 * the following board-specific configurations are necessary:
 *
 * BRD4181A (xG21):
 * 		- Connect Jumper between PA00 (WSTK breakout connector J101, pin 14 [P14]) and Push Button 0 (PD02/[P4])
 * 		- PA00 = WSTKBO P14
 * 		- Push Button 0 =  PD02 = WSTKBO P4
 *
 * BRD4182A	(xG22):
 * 		- Push Button 0 =  PB00 (ok for EM2 wakeup, no jumper needed)
 */
#if defined(_SILICON_LABS_32B_SERIES_2_CONFIG_1)  //BRD4181A
#define GPIO_INPUT_PORT       gpioPortA
#define GPIO_INPUT_PIN        0
#define BO_GPIO_IN            14
#else	//BRD4182A
#define GPIO_INPUT_PORT       BSP_GPIO_PB0_PORT
#define GPIO_INPUT_PIN        BSP_GPIO_PB0_PIN
#endif

// expansion header pin 8, also DISP_CLK
#define GPIO_INT_TOGGLE_PORT  BSP_EXP_HEADER8_PORT//gpioPortC
#define GPIO_INT_TOGGLE_PIN   BSP_EXP_HEADER8_PIN//2
#define EXP_GPIO_OUT          8

// expansion header pin 10, also DISP_SCS
#define HFXO_RDY_PORT         BSP_EXP_HEADER10_PORT//gpioPortC
#define HFXO_RDY_PIN          BSP_EXP_HEADER10_PIN//3
#define EXP_HFXO_RDY          10
        
#define RECOVERY_PORT       BSP_GPIO_PB1_PORT
#define RECOVERY_PIN        BSP_GPIO_PB1_PIN

#endif /* MAIN_CMU_HFXO_AUTOSTART_H */
