/*****************************************************************************
 * @file main_rtcdriver.c
 * @brief Real Time Counter Driver Demo Application
 * @author Silicon Labs
 * @version 1.09
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/
 
#include <stdio.h>
#include "em_chip.h"
#include "em_emu.h"
#include "rtcdriver.h"
#include "bsp.h"

#define WAKEUP_INTERVAL_MS      500

RTCDRV_TimerID_t id;


/**************************************************************************//**
 * @brief RTC Callback to toggle LED
 *****************************************************************************/
void rtcCallback( RTCDRV_TimerID_t id, void *user )
{
  BSP_LedToggle(0);
  BSP_LedToggle(1);
}


/**************************************************************************//**
 * @brief  Main function
 *****************************************************************************/
int main( void )
{
  /* Chip errata */
  CHIP_Init();

#if defined( _EMU_DCDCCTRL_MASK )
  /* Init DCDC regulator */
  EMU_DCDCInit_TypeDef dcdcInit = EMU_DCDCINIT_DEFAULT;
  EMU_DCDCInit(&dcdcInit);
#endif

  /* Initialize RTC driver. */
  RTCDRV_Init();
  RTCDRV_AllocateTimer( &id );
  RTCDRV_StartTimer( id, rtcdrvTimerTypePeriodic, WAKEUP_INTERVAL_MS, rtcCallback, NULL );
  
  /* Initialize LED driver */
  BSP_LedsInit();
  BSP_LedSet(0);
  BSP_LedClear(1);
  
  while (1)
  {
    EMU_EnterEM2(false);
  }
}
