/**************************************************************************//**
 * @file config.h
 * @brief Configuration for the demo.
 * @author Silicon Labs
 * @version  1.11

 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2017 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/
#ifndef __CONFIG_H__
#define __CONFIG_H__

// Strings 
#define STR_WAKEUP_BURTC  "BURTCWU"
#define STR_WAKEUP_CRYO   "CRYO WU"

#if defined(BURTC_PRESENT)
	#define STR_WAKEUP_TIMER   STR_WAKEUP_BURTC
	// Set sleep time 
	#define ULFRCO_FREQUENCY        1000
	#define BURTC_TIMEOUT_S         2
	#define BURTC_COUNT_TO_WAKEUP   (ULFRCO_FREQUENCY * BURTC_TIMEOUT_S)
#elif defined(CRYOTIMER_PRESENT)
	#define STR_WAKEUP_TIMER   STR_WAKEUP_CRYO
#else
	#define STR_WAKEUP_TIMER   "NO TIMER"
#endif

#define STR_WAKEUP_RESET  "RESET"
#define STR_WAKEUP_GPIO   "GPIO WU"


#if defined(SEGMENT_LCD)
	#include "segmentlcd.h"
	#define displayInit()	  SegmentLCD_Init(false)
	#define displayString(x)  SegmentLCD_Write(x)
	#if defined(BURTC_PRESENT)
		#define displayNumber(x)  SegmentLCD_Number(x)
	#else
		#define displayNumber(x)
	#endif
	#define displayOff()	  SegmentLCD_Disable()
#elif defined(TFT_LCD)
	#include "display.h"
	#include "textdisplay.h"
	#include "retargettextdisplay.h"
	extern DISPLAY_Device_t displayDevice;

	#define displayInit()	  DISPLAY_Init(); RETARGET_TextDisplayInit()
	#define displayString(x)  printf("\f\n\n\n\n\n%s",x)

	#if defined(BURTC_PRESENT)
		#define displayNumber(x)  printf("\nCount = %x",(unsigned int)x)
	#else
		#define displayNumber(x)
	#endif
	#define displayOff() DISPLAY_DeviceGet( 0, &displayDevice ); \
	displayDevice.pDisplayPowerOn(&displayDevice, false)
#endif

#if defined(_SILICON_LABS_32B_SERIES_0)
	#define EM4_WU_PB_EN (GPIO_EM4WUEN_EM4WUEN_F1)
	#define GPIO_EM4WUIF (GPIO->EM4WUCAUSE & GPIO_EM4WUCAUSE_EM4WUCAUSE_F1)
#else
	#include "bspconfig.h"
	#if defined(BSP_STK_BRD2204A)  // EFM32GG11 doesn't has the em4config.h file
		#define EM4_WU_PB_EN        (1 << 18) // GPIO_EM4WU2 = PC9 = pushbutton 1 
	#else
		#include "em4config.h"
	#endif
	#define GPIO_EM4WUIF (GPIO->IF & EM4_WU_PB_EN)
#endif

#if defined(_GPIO_EM4WUEN_MASK)
	#define enableGPIOWakeup()  GPIO_EM4EnablePinWakeup(EM4_WU_PB_EN, 0)
#endif



#endif
