/**************************************************************************//**
 * @file prime.c
 * @brief EM0 power consumption benchmark
 * @author Silicon Labs
 * @version  1.11

 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2017 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/
#include <stdlib.h>
#include "em_device.h"
#include "em_cmu.h"
#include "config.h"

#define PRIM_NUMS 64

/**************************************************************************//**
 * @brief   Compute Prime forever
 *****************************************************************************/
void computePrimesForever(void)
{
  uint32_t i, d, n;
  uint32_t primes[PRIM_NUMS];

  // Find prime numbers forever
  while (1)
  {
    primes[0] = 1;
    for (i = 1; i < PRIM_NUMS;)
    {
      for (n = primes[i - 1] + 1; ; n++)
      {
        for (d = 2; d <= n; d++)
        {
          if (n == d)
          {
            primes[i] = n;
            goto nexti;
          }
          if (n % d == 0) { break; }
        }
      }
nexti:
      i++;
    }
  }
}

/**************************************************************************//**
 * @brief  prime function
 *****************************************************************************/
void prime(void)
{
  // Enable HFXO
  CMU_OscillatorEnable(cmuOsc_HFXO, true, true);
  // Set HFXO for HF clock.
  CMU_ClockSelectSet(cmuClock_HF, cmuSelect_HFXO);

  // Disable HFRCO
  CMU_OscillatorEnable(cmuOsc_HFRCO, false, true);

  // Disable all peripheral clocks
#if defined( _CMU_HFCORECLKEN0_MASK )
  CMU->HFCORECLKEN0 = CMU_HFCORECLKEN0_LE;
#endif
#if defined( _CMU_HFBUSCLKEN0_MASK )
  CMU->HFBUSCLKEN0 = CMU_HFBUSCLKEN0_LE;
#endif
  CMU->HFPERCLKEN0  = 0;
#if defined(_CMU_HFPERCLKEN1_MASK)
  CMU->HFPERCLKEN1  = 0;
#endif

  CMU->LFACLKEN0 = 0;
  CMU->LFBCLKEN0 = 0;
#if defined( _CMU_LFCCLKEN0_MASK )
  CMU->LFCCLKEN0 = 0;
#endif
#if defined( _CMU_LFECLKEN0_MASK )
  CMU->LFECLKEN0 = 0;
#endif
  // Compute prime numbers forever
  computePrimesForever();
}
