/******************************************************************************
 * @file 4_energymodes_pg.c
 * @brief Energy Modes example
 * @author Silicon Labs
 * @version  1.23

 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2017 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/

/* emlib includes */
#include "em_chip.h"
#include "em_device.h"
#include "em_cmu.h"
#include "em_emu.h"
#include "em_rtcc.h"

#define LFRCO_FREQUENCY              32768
#define WAKEUP_INTERVAL_MS           5000
/* The -1 compensates for RTCC CNT is CC1_CCV+1 after a compare match event */ 
#define RTC_COUNT_BETWEEN_WAKEUP    (((LFRCO_FREQUENCY * WAKEUP_INTERVAL_MS) / 1000)-1)

RTCC_Init_TypeDef rtccInit;
RTCC_CCChConf_TypeDef rtccInitCompareChannel;

/******************************************************************************
 * @brief RTCC Interrupt Handler. Clears interrupt flag.
 *        The interrupt table is in assembly startup file startup_efm32.s
 *****************************************************************************/
void RTCC_IRQHandler(void)
{
  /* Clear interrupt source */
  
  /* ENTER YOUR CODE HERE */
}

/******************************************************************************
 * @brief  Main function
 *
 *****************************************************************************/
int main(void)
{ 
  /* Initialize chip */
  CHIP_Init();  

  /* ENTER YOUR CODE HERE */

  /* Init DCDC regulator */

  /* Starting LFRCO and waiting until it is stable */

  /* Enable the RTCC clock*/

  /* Enabling clock to the interface of the low energy modules */
  
  /* Set up RTCC init struct */
  //rtccInit.enable = ?;
  //rtccInit.debugRun = ?;
  //rtccInit.precntWrapOnCCV0 = ?;
  //rtccInit.cntWrapOnCCV1 = ?;
  //rtccInit.presc = ?;
  //rtccInit.prescMode = ?;
  //rtccInit.enaOSCFailDetect = ?;
  //rtccInit.cntMode = ?;
  //rtccInit.disLeapYearCorr = ?;

  /* Input RTCC init struct in initialize function */
  
  /* Set up RTCC channel output compare init structure */
  //rtccInitCompareChannel.chMode = ?;
  //rtccInitCompareChannel.compMatchOutAction = ?;
  //rtccInitCompareChannel.prsSel = ?;
  //rtccInitCompareChannel.inputEdgeSel = ?;
  //rtccInitCompareChannel.compBase = ?;
  //rtccInitCompareChannel.compMask = ?;
  //rtccInitCompareChannel.dayCompMode = ?;

  /* Input RTCC channel output compare init struct in initialize function */

  /* Set RTCC compare value */
  
  /* Enable RTCC interrupt from CC1 */
  
  /* Enable RTCC interrupt vector in NVIC */
  
  /* Enable RTCC */

  /* Enter EM2 and wait for RTCC interrupt */
   
  /* Wait in this loop at end of program */
  while(1);
}
