/**************************************************************************//**
 * @file main_eeprom_emulation.h
 * @brief main EEPROM Emulation Demo Application header file
 * @author Silicon Labs
 * @version 1.09
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2014 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/

#ifndef __MAIN_EE_H
#define __MAIN_EE_H

#include <stdbool.h>
#include "em_device.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef  SEGMENT_LCD
#include "segmentlcd.h"
#define DisplayInit()			SegmentLCD_Init(false)
#define DisplayNumber(num)		SegmentLCD_Number(num)
#define DisplayString(str)		SegmentLCD_Write(str)
#endif

#ifdef MEMORY_LCD
#include "display.h"
#include "textdisplay.h"
#include "retargettextdisplay.h"

static void DisplayInit()
{
  /* Initialize the display module. */
  DISPLAY_Init();

  /* Retarget stdio to a text display. */
  if (RETARGET_TextDisplayInit() != TEXTDISPLAY_EMSTATUS_OK)
  {
    while (1) ;
  }
  printf("\nEEPROM Emulation\n\n\n\n");
}

#define DisplayNumber(num) printf("\r  count = %d", num)
#define DisplayString(str) printf("\n\n\n    %s", str)
#endif

#ifdef __cplusplus
}
#endif

#endif /* __EE_H */
