/**************************************************************************//**
 * @file main_prs_example.h
 * @brief PRS Examples for EFM32 Gecko Series 0 and 1
 * @version 1.0.8
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef MAIN_PRS_EXAMPLE_H
#define MAIN_PRS_EXAMPLE_H

#include "em_acmp.h"
#include "em_adc.h"
#include "em_chip.h"
#include "em_cmu.h"
#include "em_device.h"
#include "em_emu.h"
#include "em_gpio.h"
#include "em_pcnt.h"
#include "em_prs.h"
#include "em_timer.h"
#include "em_usart.h"

/* Push buttons used on different EFM32 STKs */
#if defined(_EFM32_GIANT_FAMILY) || defined(_EFM32_WONDER_FAMILY) || defined(_EFM32_LEOPARD_FAMILY) || defined(_EFM32_GECKO_FAMILY)
#define USE_SEGMENT_LCD
#define BSP_GPIO_PB0_PORT       gpioPortB
#define BSP_GPIO_PB0_PIN        9
#define BSP_GPIO_PB1_PORT       gpioPortB
#define BSP_GPIO_PB1_PIN        10
#elif defined(_EFM32_TINY_FAMILY)
#define USE_SEGMENT_LCD
#define BSP_GPIO_PB0_PORT       gpioPortD
#define BSP_GPIO_PB0_PIN        8
#define BSP_GPIO_PB1_PORT       gpioPortB
#define BSP_GPIO_PB1_PIN        11
#elif defined(_EFM32_PEARL_FAMILY) || defined(_SILICON_LABS_32B_PLATFORM_2)
#include "bspconfig.h"
#else
#error "STK does not support in this application note"
#endif

#if defined(USE_SEGMENT_LCD)
#include "em_dac.h"
#include "em_lcd.h"
#include "segmentlcd.h"
#else
#include <stdio.h>
#include "em_rtcc.h"
#include "display.h"
#include "textdisplay.h"
#include "retargettextdisplay.h"
#endif

/* USART used on different EFM32 STKs */
#if defined(USE_SEGMENT_LCD)
#define USART_CLOCK             cmuClock_USART1
#define USART_USE               USART1
#else
#define USART_CLOCK             cmuClock_USART0
#define USART_USE               USART0
#endif

/* Menu items */
#define PRS_ADC                 0
#define PRS_PUL                 1
#define PRS_USART               2

#if defined(USE_SEGMENT_LCD)
#define PRS_DAC                 3
#define PRS_MON                 4
#define PRS_PCNT                5
#else
#define PRS_PCNT                3
#define PRS_WFE                 4
#define PRS_LOGIC               5
#endif

#if defined(_EFM32_GECKO_FAMILY)
#define MENU_MAX                5
#else
#define MENU_MAX                6
#endif

/* Functions prototype */
void gpioSetup(void);
void printMenu(void);
void prsDemoExit(void);
void prsTimerAdc(void);
void prsAcmpCapture(void);
void prsGpioUsart(void);
void prsSwDac(void);
void prsMonitor(void);
void prsGpioPcnt(void);
void prsTimerWfe(void);
void prsConfigLogic(void);

/* External variables */
extern volatile bool runKey;
extern volatile bool menuKey;
extern volatile bool progRun;
extern volatile uint8_t menuLevel;
extern volatile uint32_t bufferTemp;

#endif /* MAIN_PRS_EXAMPLE_H */
