/******************************************************************************
 * @file config.h
 * @brief LETIMER Demo Application
 * @author Silicon Labs
 * @version  1.09

 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2017 Silicon Labs, http://www.silabs.com</b>
 ******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/
#include "em_letimer.h"

/* MACRO */
/* LETIMER routed to below pin for different parts */
#if defined ( STK_Gxxx ) || defined ( STK3300 ) || defined ( STK3600 ) || \
                            defined ( STK3700 ) || defined ( STK3800 )
/* Series 0 STK */
#define LETIMER_OUT0_PORT gpioPortD
#define LETIMER_OUT0_PIN 6
#define LETIMER_OUT1_PORT gpioPortD
#define LETIMER_OUT1_PIN 7
#elif defined ( SLSTK3701 )
/* GG11 STK (series 1) */
#define LETIMER_OUT0_PORT gpioPortD
#define LETIMER_OUT0_PIN 6
#define LETIMER_OUT1_PORT gpioPortD
#define LETIMER_OUT1_PIN 7
#define START_PRS_CH_CRTL_SOURCE_GPIO PRS_CH_CTRL_SOURCESEL_GPIOH
#define STOP_PRS_CH_CRTL_SOURCE_GPIO PRS_CH_CTRL_SOURCESEL_GPIOH
#elif defined ( SLSTK3301 )
/* TG11 STK (series 1) */
#define LETIMER_OUT0_PORT gpioPortD
#define LETIMER_OUT0_PIN 6
#define LETIMER_OUT1_PORT gpioPortD
#define LETIMER_OUT1_PIN 7
#define START_PRS_CH_CRTL_SOURCE_GPIO PRS_CH_CTRL_SOURCESEL_GPIOL
#define STOP_PRS_CH_CRTL_SOURCE_GPIO PRS_CH_CTRL_SOURCESEL_GPIOH
#elif defined ( SLSTK3401 ) || defined ( SLSTK3402 ) || defined ( SLSTK3702 )
/* Other series 1 STK */
#define LETIMER_OUT0_PORT gpioPortA
#define LETIMER_OUT0_PIN 0
#define LETIMER_OUT1_PORT gpioPortA
#define LETIMER_OUT1_PIN 1
#define START_PRS_CH_CRTL_SOURCE_GPIO PRS_CH_CTRL_SOURCESEL_GPIOL
#define STOP_PRS_CH_CRTL_SOURCE_GPIO PRS_CH_CTRL_SOURCESEL_GPIOL
#else
#error "undefined KIT"
#endif

#if defined ( STK_Gxxx ) || defined ( STK3300 ) || defined ( STK3600 ) || \
                            defined ( STK3700 ) || defined ( STK3800 )
/* Series 0 with segment LCD */
/* EFM32TG11 is an exception */
/* EFM32ZG and EFM32HG don't have LETIMER peripheral */
#define SEG_LCD_S0
#elif defined ( SLSTK3301 )
/* EFM32TG11 is series 1 with segment LCD */
#define SEG_LCD_S1                  
#else
/* Series 1 with TFT LCD */
#define TFT_LCD_S1
#endif

typedef enum
{
  // Series 0 don't support PRS tigger LETIMER
  // Series 1 would support PRS tigger LETIMER
  // Series 0 would support 2 test modes
  // 1. Software start continuous PWM and pulse output
  // 2. RTC start one-shot pulse output
  // Series 1 would support 3 test modes
  // 1. Software start continuous PWM and pulse output
  // 2. RTCC start one-shot pulse output
  // 3. GPIO start/stop continuous pulse output
  T_PWM,
#if defined( RTCC_COUNT ) && ( RTCC_COUNT == 1 )
  T_RTCC,
#else
  T_RTC,
#endif
#if defined (_LETIMER_PRSSEL_MASK)
  T_GPIO,
#endif
  T_END
} testMode_TypeDef;

/* Global variables */
extern volatile testMode_TypeDef tMode;            /* Selected test mode */
extern volatile unsigned int startTest;            /* Start test key pressed */

/* Function declaration */
void setupGpio(void);
int selectState(void);
void initLcd(void);
void setupLetimer(testMode_TypeDef tMode);
void modeTest(testMode_TypeDef tMode);

/* Both Series 0 and series 1 suport software start */
void testPWM(void);

#if defined( RTCC_COUNT ) && ( RTCC_COUNT == 1 )
/* Series 1 would only support PRS trigger LETIMER directly */
void setupRtcc(void);
void testRTCC(void);
void prsRtccSetup(void);
#else
/* Series 0 would only support RTC start LETIMER directly */
void setupRtc(void);
void testRTC(void);
#endif

#if defined ( _LETIMER_PRSSEL_MASK )
/* Series 1 would also support other PRS source
 * like GPIO trigger LETIMER directly */
void testGPIO(void);
void prsGpioSetup(void);
#endif

#if defined ( TFT_LCD_S1 )
#define lcd_Write(str) printf(str);
#else
#define lcd_Write(str) SegmentLCD_Write(str);
#endif
