/******************************************************************************
 * @file main_letimer.c
 * @brief LETIMER demo application
 * @author Silicon Labs
 * @version  1.09

 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2017 Silicon Labs, http://www.silabs.com</b>
 ******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/
#include "em_device.h"
#include "em_chip.h"
#include "em_emu.h"
#include "config.h"

/* GLOBAL VARIABLE */
volatile testMode_TypeDef tMode;        /* Selected test mode */
volatile unsigned int startTest;        /* Start test key pressed */

/******************************************************************************
 * @brief  Main function
 * Main is called from __iar_program_start, see assembly startup file
 *****************************************************************************/
int main(void)
{
  // Align different chip revisions
  CHIP_Init();

#if defined( _EMU_DCDCCTRL_MASK )
  // Init DCDC regulator
  EMU_DCDCInit_TypeDef dcdcInit = EMU_DCDCINIT_DEFAULT;
  EMU_DCDCInit(&dcdcInit);
#endif
  
  // Initialize LCD controller
  initLcd();
  
  // Initialize button GPIO to let user select test item
  setupGpio();
  
  // Loop test mode and wait start key pressing
  selectState();

  // Run the test
  modeTest(tMode);

  while (1)
  {
    // Go to EM2
    EMU_EnterEM2(false);
  }
}
