/**************************************************************************//**
 * @file AX88796C_if.h
 * @brief Prototypes for AX88796C Ethernet interface.
 *        This file is derived from the ``ethernetif.h'' skeleton Ethernet network
 *        interface driver for lwIP.
 *        
 * @author Silicon Labs
 * @version 1.08
 ******************************************************************************/

/*
 * Copyright (c) 2001-2004 Swedish Institute of Computer Science.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
 * OF SUCH DAMAGE.
 *
 * This file is part of the lwIP TCP/IP stack.
 *
 * Author: Adam Dunkels <adam@sics.se>
 *
 */

#ifndef __AX88796C_IF_H__
#define __AX88796C_IF_H__

extern int AX88796Cif_input(struct netif *netif);
extern err_t AX88796Cif_init(struct netif *netif);
extern void AX88796Cif_interrupt(struct netif *netif);
extern void evn_router_interrupt0_handler(void);
static err_t low_level_output(struct netif *netif, struct pbuf *p);

#if NETIF_DEBUG
void AX88796Cif_debug_print(struct pbuf *p);
#else
#define AX88796Cif_debug_print(p)
#endif /* NETIF_DEBUG */

#endif /* __AX88796C_IF_H__ */
