/***************************************************************************//**
 * @file opamp.h
 * @brief Functions for different OPAMP configurations, header file
 * @version  1.00

 *******************************************************************************
 * # License
 * <b>Copyright 2019 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

#ifndef OPAMP_H
#define OPAMP_H

#include "em_gpio.h"
#include "em_opamp.h"

#if defined(VDAC_STATUS_OPA3ENS)
// EFM32GG11/12 and EFM32TG11 POSPAD, NEGPAD, and APORT
#define POS0PORT        gpioPortC
#define POS0PIN         4
#define POS1PORT        gpioPortD
#define POS1PIN         6
#define POS2PORT        gpioPortD
#define POS2PIN         4
#define POS3PORT        gpioPortC
#define POS3PIN         6

#define NEG0PORT        gpioPortC
#define NEG0PIN         5
#define NEG1PORT        gpioPortD
#define NEG1PIN         7
#define NEG2PORT        gpioPortD
#define NEG2PIN         3
#define NEG3PORT        gpioPortC
#define NEG3PIN         7

#define APORT1XPORTLOW  gpioPortA
#define APORT1XPORTHIGH gpioPortB
#define APORT2XPORTLOW  gpioPortA
#define APORT2XPORTHIGH gpioPortB
#define APORT3XPORTLOW  gpioPortE
#define APORT3XPORTHIGH gpioPortF
#define APORT4XPORTLOW  gpioPortE
#define APORT4XPORTHIGH gpioPortF

#define APORT1YPORTLOW  gpioPortA
#define APORT1YPORTHIGH gpioPortB
#define APORT2YPORTLOW  gpioPortA
#define APORT2YPORTHIGH gpioPortB
#define APORT3YPORTLOW  gpioPortE
#define APORT3YPORTHIGH gpioPortF
#define APORT4YPORTLOW  gpioPortE
#define APORT4YPORTHIGH gpioPortF
#else
// EFM32xG12 and EFR32xG12/13/14 POSPAD, NEGPAD, and APORT
#define POS0PORT        gpioPortA
#define POS0PIN         2
#define POS1PORT        gpioPortD
#define POS1PIN         13
#define POS2PORT        gpioPortB
#define POS2PIN         11

#define NEG0PORT        gpioPortA
#define NEG0PIN         4
#define NEG1PORT        gpioPortD
#define NEG1PIN         15
#define NEG2PORT        gpioPortB
#define NEG2PIN         13

#define APORT1XPORTLOW  gpioPortC
#define APORT1XPORTHIGH gpioPortF
#define APORT2XPORTLOW  gpioPortC
#define APORT2XPORTHIGH gpioPortF
#define APORT3XPORTLOW0 gpioPortD
#define APORT3XPORTLOW1 gpioPortA
#define APORT3XPORTHIGH gpioPortB
#define APORT4XPORTLOW0 gpioPortD
#define APORT4XPORTLOW1 gpioPortA
#define APORT4XPORTHIGH gpioPortB

#define APORT1YPORTLOW  gpioPortC
#define APORT1YPORTHIGH gpioPortF
#define APORT2YPORTLOW  gpioPortC
#define APORT2YPORTHIGH gpioPortF
#define APORT3YPORTLOW0 gpioPortD
#define APORT3YPORTLOW1 gpioPortA
#define APORT3YPORTHIGH gpioPortB
#define APORT4YPORTLOW0 gpioPortD
#define APORT4YPORTLOW1 gpioPortA
#define APORT4YPORTHIGH gpioPortB
#endif

// Functions
void posSelOvtDisable(OPAMP_TypeDef opaSelect, OPAMP_PosSel_TypeDef posInput);

void negSelOvtDisable(OPAMP_TypeDef opaSelect, OPAMP_NegSel_TypeDef negInput);

void resInOvtDisable(OPAMP_TypeDef opaSelect,
                     OPAMP_ResInMux_TypeDef resInInput);

void opaGeneralMode(OPAMP_TypeDef opaSelect,
                    OPAMP_PosSel_TypeDef posInput,
                    OPAMP_NegSel_TypeDef negInput,
                    OPAMP_OutMode_TypeDef opaOutput,
                    uint32_t altOutMask);
					
void opaUnityGain(OPAMP_TypeDef opaSelect,
                  OPAMP_PosSel_TypeDef posInput,
                  OPAMP_OutMode_TypeDef opaOutput,
                  uint32_t altOutMask);
				  
void opaNonInvertAmp(OPAMP_TypeDef opaSelect,
                     OPAMP_PosSel_TypeDef posInput,
                     OPAMP_ResSel_TypeDef resLadderRatio,
                     OPAMP_OutMode_TypeDef opaOutput,
                     uint32_t altOutMask);

void opaInvertAmp(OPAMP_TypeDef opaSelect,
                  OPAMP_ResInMux_TypeDef resInInput,
                  OPAMP_PosSel_TypeDef posInput,
                  OPAMP_ResSel_TypeDef resLadderRatio,
                  OPAMP_OutMode_TypeDef opaOutput,
                  uint32_t altOutMask);
				  
void opaCascadeTwoNonInvertAmp(OPAMP_TypeDef firstStage,
                               OPAMP_PosSel_TypeDef posInput0,
                               OPAMP_ResSel_TypeDef resSel0,
                               OPAMP_ResSel_TypeDef resSel1,
                               OPAMP_OutMode_TypeDef opaOutput,             
                               uint32_t altOutMask);

void opaCascadeThreeNonInvertAmp(OPAMP_TypeDef firstStage,
                                 OPAMP_PosSel_TypeDef posInput0,
                                 OPAMP_ResSel_TypeDef resSel0,
                                 OPAMP_ResSel_TypeDef resSel1,
                                 OPAMP_ResSel_TypeDef resSel2,
                                 OPAMP_OutMode_TypeDef opaOutput,             
                                 uint32_t altOutMask);

void opaCascadeFourNonInvertAmp(OPAMP_PosSel_TypeDef posInput0,
                                OPAMP_ResSel_TypeDef resSel0,
                                OPAMP_ResSel_TypeDef resSel1,
                                OPAMP_ResSel_TypeDef resSel2,
                                OPAMP_ResSel_TypeDef resSel3,
                                OPAMP_OutMode_TypeDef opaOutput,             
                                uint32_t altOutMask);

void opaCascadeTwoInvertAmp(OPAMP_TypeDef firstStage,
                            OPAMP_ResInMux_TypeDef resInInput,
                            OPAMP_PosSel_TypeDef posInput0,
                            OPAMP_ResSel_TypeDef resSel0,
                            OPAMP_PosSel_TypeDef posInput1,
                            OPAMP_ResSel_TypeDef resSel1,
                            OPAMP_OutMode_TypeDef opaOutput,
                            uint32_t altOutMask);              
					 
void opaCascadeThreeInvertAmp(OPAMP_TypeDef firstStage,
                              OPAMP_ResInMux_TypeDef resInInput,
                              OPAMP_PosSel_TypeDef posInput0,
                              OPAMP_ResSel_TypeDef resSel0,
                              OPAMP_PosSel_TypeDef posInput1,
                              OPAMP_ResSel_TypeDef resSel1,
                              OPAMP_PosSel_TypeDef posInput2,
                              OPAMP_ResSel_TypeDef resSel2,
                              OPAMP_OutMode_TypeDef opaOutput,
                              uint32_t altOutMask);              

void opaCascadeFourInvertAmp(OPAMP_ResInMux_TypeDef resInInput,
                             OPAMP_PosSel_TypeDef posInput0,
                             OPAMP_ResSel_TypeDef resSel0,
                             OPAMP_PosSel_TypeDef posInput1,
                             OPAMP_ResSel_TypeDef resSel1,
                             OPAMP_PosSel_TypeDef posInput2,
                             OPAMP_ResSel_TypeDef resSel2,
                             OPAMP_PosSel_TypeDef posInput3,
                             OPAMP_ResSel_TypeDef resSel3,
                             OPAMP_OutMode_TypeDef opaOutput,
                             uint32_t altOutMask);              

void opaTwoDiffAmp(OPAMP_TypeDef firstStage,
                   OPAMP_PosSel_TypeDef posInput0,
                   OPAMP_PosSel_TypeDef posInput1,
                   OPAMP_ResSel_TypeDef resSel1,
                   OPAMP_OutMode_TypeDef opaOutput,             
                   uint32_t altOutMask);              
				  
void opaThreeDiffAmp(OPAMP_PosSel_TypeDef posInput0,
                     OPAMP_PosSel_TypeDef posInput1,
                     OPAMP_ResSel_TypeDef resSel0,
                     OPAMP_ResSel_TypeDef resSel2,
                     OPAMP_OutMode_TypeDef opaOutput,             
                     uint32_t altOutMask);              

void opaInstrAmp(OPAMP_TypeDef firstStage,
                 OPAMP_PosSel_TypeDef posInput0,
                 OPAMP_PosSel_TypeDef posInput1,
                 OPAMP_ResSel_TypeDef resSel0,
                 OPAMP_ResSel_TypeDef resSel1,
                 OPAMP_OutMode_TypeDef opaOutput0,             
                 OPAMP_OutMode_TypeDef opaOutput1,             
                 uint32_t altOutMask0,
                 uint32_t altOutMask1);              

void initOpaPrs(OPAMP_TypeDef opaSelect,
                OPAMP_PrsMode_TypeDef opaPrsMode,
                OPAMP_PrsSel_TypeDef opaPrsInCh,
                OPAMP_PrsOut_TypeDef opaPrsOut,
                uint32_t opaPrsOutCh);
#endif // OPAMP_H
