/***************************************************************************//**
 * @file opamp_acmp.c
 * @brief Functions for OPA as ACMP input front-end example
 * @version  1.00

 *******************************************************************************
 * # License
 * <b>Copyright 2019 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

#include "em_acmp.h"
#include "em_cmu.h"
#include "em_opamp.h"
#include "opamp_acmp.h"

/**************************************************************************//**
 * @brief ACMP0 Handler
 *****************************************************************************/
void ACMP0_IRQHandler(void)
{
  // Clear interrupt flag
  ACMP_IntClear(ACMP0, ACMP_IFC_EDGE);
}

/**************************************************************************//**
 * @brief ACMP initialization
 *****************************************************************************/
void initAcmp(void)
{
  // Enable clock
  CMU_ClockEnable(cmuClock_ACMP0, true);

  // Set ACMP initialization to the default
  ACMP_Init_TypeDef acmpInit = ACMP_INIT_DEFAULT;

  // Delay enabling ACMP until after everything has been set
  acmpInit.enable = false;

  // ACMP interrupts when voltage on POS channel drops below NEG channel
  acmpInit.interruptOnFallingEdge = true;
  
  // Initialize and set ACMP channel
  ACMP_Init(ACMP0, &acmpInit);

  // Configure OPA outputs as NEG and POS inputs
  ACMP_ChannelSet(ACMP0, ACMP_NEG_INPUT, ACMP_POS_INPUT);

  // Enable ACMP
  ACMP_Enable(ACMP0);

  // Wait for warmup
  while (!(ACMP0->STATUS & _ACMP_STATUS_ACMPACT_MASK))
    ;

  // Clear pending ACMP interrupts
  NVIC_ClearPendingIRQ(ACMP0_IRQn);
  ACMP_IntClear(ACMP0, ACMP_IFC_EDGE);

  // Enable ACMP interrupts
  NVIC_EnableIRQ(ACMP0_IRQn);
  ACMP_IntEnable(ACMP0, ACMP_IEN_EDGE);
}
