/***************************************************************************//**
 * @file opamp_adc.h
 * @brief Functions for OPA as ADC input front-end example, header file
 * @version  1.00

 *******************************************************************************
 * # License
 * <b>Copyright 2019 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

#ifndef OPAMP_ADC_H
#define OPAMP_ADC_H

#define USE_OPA_PRS             1               // Enable(1)/Disable(0) OPA PRS

// Defines for LETIMER
#define LETIMER_CLKSRC          cmuSelect_LFXO  // LFRCO or LFXO as clock source
#define LETIMER_FREQ            16              // PRS trigger frequency
#define LETIMER_COMPARE         (32768 / LETIMER_FREQ - 1)
#if (USE_OPA_PRS == 1)
#define PRS_OPA_CHANNEL         1
#define OPA_PRS_CHANNEL         opaPrsSelCh1    // Match with PRS_OPA_CHANNEL
#endif

// Defines for ADC
#define PRS_ADC_CHANNEL         2
#define ADC_PRS_CHANNEL         adcPRSSELCh2    // Match with PRS_ADC_CHANNEL
#define ADC_LDMA_CHANNEL        0
#define ADC_BUFFER_SIZE         16              // Samples per DMA interrupt
#define ADC_REF                 adcRefVDD       // ADC reference source
#define ADC_AT                  adcAcqTime1     // ADC acquisition time
#define ADC_ASYNC_CLOCK         cmuAUXHFRCOFreq_4M0Hz
#define ADC_FREQ                1000000
#define ADC_SINGLE_DVL          4               // Samples for one DMA transfer

// Functions
void initAdc(void);
void initLdma(void);
void initLetimer(void);
void printVoltage(void);

#endif // OPAMP_ADC_H
