/***************************************************************************//**
 * @file opamp_config.h
 * @brief OPAMP configurations for examples
 * @version  1.00

 *******************************************************************************
 * # License
 * <b>Copyright 2019 Silicon Laboratories Inc. www.silabs.com</b>
 *******************************************************************************
 *
 * The licensor of this software is Silicon Laboratories Inc. Your use of this
 * software is governed by the terms of Silicon Labs Master Software License
 * Agreement (MSLA) available at
 * www.silabs.com/about-us/legal/master-software-license-agreement. This
 * software is distributed to you in Source Code format and is governed by the
 * sections of the MSLA applicable to Source Code.
 *
 ******************************************************************************/

#ifndef OPAMP_CONFIG_H
#define OPAMP_CONFIG_H

#include "em_opamp.h"

#if defined(EFM32GG11B820F2048GL192)
// Defines for general OPA mode example
#define GM_OPA          OPA1
#define GM_POS          opaPosSelPosPad         // PD6  
#define GM_NEG          opaNegSelNegPad         // PD7
#define GM_OUT          opaOutModeAlt           // Alternate output            
#define GM_ALTMASK      0x0100                  // PD1

// Defines for unity gain voltage follower example
#define UG_OPA          OPA0
#define UG_POS          opaPosSelAPORT3XCH10    // PE10
#define UG_OUT          opaOutModeAPORT4YCH12   // PE12
#define UG_ALTMASK      0                       // Don't use

// Defines for non-inverting amplifier example
#define NIA_OPA         OPA0
#define NIA_POS         opaPosSelAPORT3XCH10    // PE10
#define NIA_RESSEL      opaResSelR2eqR1         // R2 = R1
#define NIA_OUT         opaOutModeAPORT4YCH12   // PE12     
#define NIA_ALTMASK     0                       // Don't use

// Defines for inverting amplifier example
#define IA_OPA          OPA0
#define IA_RESIN        opaResInMuxNegPad       // PC5     
#define IA_POS          opaPosSelAPORT3XCH10    // PE10       
#define IA_RESSEL       opaResSelR2eqR1         // R2 = R1
#define IA_OUT          opaOutModeAPORT4YCH12   // PE12
#define IA_ALTMASK      0                       // Don't use

// Defines for cascaded non-inverting amplifier example
#define CNIA_FIRST      OPA0
#define CNIA_POS        opaPosSelAPORT3XCH10    // PE10
#define CNIA_RESSEL0    opaResSelR2eqR1         // R2 = R1
#define CNIA_RESSEL1    opaResSelR2eqR1         // R2 = R1
#define CNIA_OUT        opaOutModeAPORT4YCH12   // PE12     
#define CNIA_ALTMASK    0                       // Don't use

// Defines for cascaded inverting amplifier example
#define CIA_FIRST       OPA0
#define CIA_RESIN       opaResInMuxNegPad       // PC5     
#define CIA_POS0        opaPosSelAPORT3XCH10    // PE10
#define CIA_RESSEL0     opaResSelR2eqR1         // R2 = R1
#define CIA_POS1        opaPosSelAPORT4XCH11    // PE11
#define CIA_RESSEL1     opaResSelR2eqR1         // R2 = R1
#define CIA_OUT         opaOutModeAPORT4YCH12   // PE12     
#define CIA_ALTMASK     0                       // Don't use

// Defines for two OPA differential amplifier example
#define DIFF2_OPA       OPA0
#define DIFF2_POS0      opaPosSelAPORT3XCH10    // PE10
#define DIFF2_POS1      opaPosSelAPORT4XCH11    // PE11
#define DIFF2_RESSEL    opaResSelR2eqR1         // R2 = R1
#define DIFF2_OUT       opaOutModeAPORT4YCH12   // PE12     
#define DIFF2_ALTMASK   0                       // Don't use

// Defines for OPA as ACMP input front-end example, must use OPA0 and OPA1
#define ACMP_POS_OPA    OPA0
#define ACMP_POS_POS    opaPosSelAPORT3XCH10    // PE10
#define ACMP_POS_RESSEL opaResSelR2eq0_33R1     // R2 = 1/3 * R1
#define ACMP_POS_OUT    opaOutModeDisable       // Disable
#define ACMP_NEG_OPA    OPA1
#define ACMP_NEG_POS    opaPosSelAPORT4XCH11    // PE11
#define ACMP_NEG_RESSEL opaResSelR2eq0_33R1     // R2 = 1/3 * R1
#define ACMP_NEG_OUT    opaOutModeDisable       // Disable

// Defines for OPA as ADC input front-end example
#define ADC_OPA         OPA0
#define ADC_INPUT       adcPosSelDAC0OUT0       // Match with ADC_OPA
#define ADC_POS         opaPosSelAPORT3XCH10    // PE10
#define ADC_RESSEL      opaResSelR2eq0_33R1     // R2 = 1/3 * R1
#define ADC_OUT         opaOutModeDisable       // Disable
#define ADC_PRS_MODE    opaPrsModeTimed         // TIMED PRS mode
#define ADC_PRS_IN_CH   OPA_PRS_CHANNEL         // PRS in channel
#define ADC_PRS_OUT     opaPrsOutOutValid       // Output valid on PRS       
#define ADC_PRS_OUT_CH  PRS_ADC_CHANNEL         // PRS out channel

// Defines for three OPA differential amplifier example, must use OPA0, 1, and 2
#define DIFF3_POS0      opaPosSelAPORT3XCH10    // PE10
#define DIFF3_POS1      opaPosSelAPORT4XCH11    // PE11
#define DIFF3_RESSEL0   opaResSelR2eq3R1        // R2 = 3 * R1
#define DIFF3_RESSEL1   opaResSelR2eq0_33R1     // R2 = 1/3 * R1
#define DIFF3_OUT       opaOutModeAPORT4YCH12   // PE12     
#define DIFF3_ALTMASK   0                       // Don't use

#elif defined(EFM32TG11B520F128GM80)
// Defines for general OPA mode example
#define GM_OPA          OPA1
#define GM_POS          opaPosSelPosPad         // PD6  
#define GM_NEG          opaNegSelNegPad         // PD7
#define GM_OUT          opaOutModeAlt           // Alternate output            
#define GM_ALTMASK      0x0040                  // PC14

// Defines for unity gain voltage follower example
#define UG_OPA          OPA1
#define UG_POS          opaPosSelPosPad         // PD6  
#define UG_OUT          opaOutModeAlt           // Alternate output 
#define UG_ALTMASK      0x0040                  // PC14

// Defines for non-inverting amplifier example
#define NIA_OPA         OPA1
#define NIA_POS         opaPosSelPosPad         // PD6
#define NIA_RESSEL      opaResSelR2eqR1         // R2 = R1
#define NIA_OUT         opaOutModeAlt           // Alternate output
#define NIA_ALTMASK     0x0040                  // PC14

// Defines for inverting amplifier example
#define IA_OPA          OPA1
#define IA_RESIN        opaResInMuxNegPad       // PD7     
#define IA_POS          opaPosSelPosPad         // PD6       
#define IA_RESSEL       opaResSelR2eqR1         // R2 = R1
#define IA_OUT          opaOutModeAlt           // Alternate output
#define IA_ALTMASK      0x0040                  // PC14

// Defines for cascaded non-inverting amplifier example
#define CNIA_FIRST      OPA1
#define CNIA_POS        opaPosSelPosPad         // PD6
#define CNIA_RESSEL0    opaResSelR2eqR1         // R2 = R1
#define CNIA_RESSEL1    opaResSelR2eqR1         // R2 = R1
#define CNIA_OUT        opaOutModeMain          // PD5 (OPA2 main output)    
#define CNIA_ALTMASK    0                       // Don't use

// Defines for cascaded inverting amplifier example
#define CIA_FIRST       OPA1
#define CIA_RESIN       opaResInMuxNegPad       // PD7     
#define CIA_POS0        opaPosSelPosPad         // PD6
#define CIA_RESSEL0     opaResSelR2eqR1         // R2 = R1
#define CIA_POS1        opaPosSelAPORT1XCH14    // PA14
#define CIA_RESSEL1     opaResSelR2eqR1         // R2 = R1
#define CIA_OUT         opaOutModeMain          // PD5 (OPA2 main output)     
#define CIA_ALTMASK     0                       // Don't use

// Defines for two OPA differential amplifier example
#define DIFF2_OPA       OPA1
#define DIFF2_POS0      opaPosSelPosPad         // PD6
#define DIFF2_POS1      opaPosSelAPORT1XCH14    // PA14
#define DIFF2_RESSEL    opaResSelR2eqR1         // R2 = R1
#define DIFF2_OUT       opaOutModeMain          // PD5 (OPA2 main output)     
#define DIFF2_ALTMASK   0                       // Don't use

// Defines for OPA as ACMP input front-end example, must use OPA0 and OPA1
#define ACMP_POS_OPA    OPA0
#define ACMP_POS_POS    opaPosSelAPORT1XCH14    // PA14
#define ACMP_POS_RESSEL opaResSelR2eq0_33R1     // R2 = 1/3 * R1
#define ACMP_POS_OUT    opaOutModeDisable       // Disable
#define ACMP_NEG_OPA    OPA1
#define ACMP_NEG_POS    opaPosSelPosPad         // PD6
#define ACMP_NEG_RESSEL opaResSelR2eq0_33R1     // R2 = 1/3 * R1
#define ACMP_NEG_OUT    opaOutModeDisable       // Disable

// Defines for OPA as ADC input front-end example
#define ADC_OPA         OPA0
#define ADC_INPUT       adcPosSelDAC0OUT0       // Match with ADC_OPA
#define ADC_POS         opaPosSelAPORT1XCH14    // PA14
#define ADC_RESSEL      opaResSelR2eq0_33R1     // R2 = 1/3 * R1
#define ADC_OUT         opaOutModeDisable       // Disable
#define ADC_PRS_MODE    opaPrsModeTimed         // TIMED PRS mode
#define ADC_PRS_IN_CH   OPA_PRS_CHANNEL         // PRS in channel
#define ADC_PRS_OUT     opaPrsOutOutValid       // Output valid on PRS       
#define ADC_PRS_OUT_CH  PRS_ADC_CHANNEL         // PRS out channel

// Defines for three OPA differential amplifier example, must use OPA0, 1, and 2
#define DIFF3_POS0      opaPosSelAPORT1XCH14    // PA14
#define DIFF3_POS1      opaPosSelPosPad         // PD6
#define DIFF3_RESSEL0   opaResSelR2eq3R1        // R2 = 3 * R1
#define DIFF3_RESSEL1   opaResSelR2eq0_33R1     // R2 = 1/3 * R1
#define DIFF3_OUT       opaOutModeMain          // PD5 (OPA2 main output)     
#define DIFF3_ALTMASK   0                       // Don't use

#elif defined(EFM32PG12B500F1024GL125) || defined(EFR32MG12P432F1024GL125) \
|| defined(EFR32MG13P632F512GM48) || defined(EFR32FG14P233F256GM48)
// Defines for general OPA mode example
#define GM_OPA          OPA0
#define GM_POS          opaPosSelAPORT2XCH9     // PC9  
#define GM_NEG          opaNegSelAPORT2YCH10    // PC10
#define GM_OUT          opaOutModeAPORT1YCH11   // PC11            
#define GM_ALTMASK      0                       // Don't use

// Defines for unity gain voltage follower example
#define UG_OPA          OPA0
#define UG_POS          opaPosSelAPORT2XCH9     // PC9
#define UG_OUT          opaOutModeAPORT1YCH11   // PC11  
#define UG_ALTMASK      0                       // Don't use

// Defines for non-inverting amplifier example
#define NIA_OPA         OPA0
#define NIA_POS         opaPosSelAPORT2XCH9     // PC9
#define NIA_RESSEL      opaResSelR2eqR1         // R2 = R1
#define NIA_OUT         opaOutModeAPORT1YCH11   // PC11     
#define NIA_ALTMASK     0                       // Don't use

// Defines for inverting amplifier example
#define IA_OPA          OPA0
#define IA_RESIN        opaResInMuxPosPad       // PA2     
#define IA_POS          opaPosSelAPORT2XCH9     // PC9       
#define IA_RESSEL       opaResSelR2eqR1         // R2 = R1
#define IA_OUT          opaOutModeAPORT1YCH11   // PC11
#define IA_ALTMASK      0                       // Don't use
        
// Defines for cascaded non-inverting amplifier example
#define CNIA_FIRST      OPA0
#define CNIA_POS        opaPosSelAPORT2XCH9     // PC9
#define CNIA_RESSEL0    opaResSelR2eqR1         // R2 = R1
#define CNIA_RESSEL1    opaResSelR2eqR1         // R2 = R1
#define CNIA_OUT        opaOutModeAPORT1YCH11   // PC11     
#define CNIA_ALTMASK    0                       // Don't use

// Defines for cascaded inverting amplifier example
#define CIA_FIRST       OPA0
#define CIA_RESIN       opaResInMuxPosPad       // PA2     
#define CIA_POS0        opaPosSelAPORT2XCH9     // PC9
#define CIA_RESSEL0     opaResSelR2eqR1         // R2 = R1
#define CIA_POS1        opaPosSelAPORT1XCH10    // PC10
#define CIA_RESSEL1     opaResSelR2eqR1         // R2 = R1
#define CIA_OUT         opaOutModeAPORT1YCH11   // PC11     
#define CIA_ALTMASK     0                       // Don't use
        
// Defines for two OPA differential amplifier example
#define DIFF2_OPA       OPA0
#define DIFF2_POS0      opaPosSelAPORT2XCH9     // PC9
#define DIFF2_POS1      opaPosSelAPORT1XCH10    // PC10
#define DIFF2_RESSEL    opaResSelR2eqR1         // R2 = R1
#define DIFF2_OUT       opaOutModeAPORT1YCH11   // PC11     
#define DIFF2_ALTMASK   0                       // Don't use

// Defines for OPA as ACMP input front-end example, must use OPA0 and OPA1
#define ACMP_POS_OPA    OPA0
#define ACMP_POS_POS    opaPosSelAPORT2XCH9     // PC9
#define ACMP_POS_RESSEL opaResSelR2eq0_33R1     // R2 = 1/3 * R1
#define ACMP_POS_OUT    opaOutModeDisable       // Disable
#define ACMP_NEG_OPA    OPA1
#define ACMP_NEG_POS    opaPosSelAPORT1XCH10    // PC10
#define ACMP_NEG_RESSEL opaResSelR2eq0_33R1     // R2 = 1/3 * R1
#define ACMP_NEG_OUT    opaOutModeDisable       // Disable

// Defines for OPA as ADC input front-end example
#define ADC_OPA         OPA0
#define ADC_INPUT       adcPosSelDAC0OUT0       // Match with ADC_OPA
#define ADC_POS         opaPosSelAPORT2XCH9     // PC9
#define ADC_RESSEL      opaResSelR2eq0_33R1     // R2 = 1/3 * R1
#define ADC_OUT         opaOutModeDisable       // Disable
#define ADC_PRS_MODE    opaPrsModeTimed         // TIMED PRS mode
#define ADC_PRS_IN_CH   OPA_PRS_CHANNEL         // PRS in channel
#define ADC_PRS_OUT     opaPrsOutOutValid       // Output valid on PRS       
#define ADC_PRS_OUT_CH  PRS_ADC_CHANNEL         // PRS out channel

#if !defined(EFR32FG14P233F256GM48)
// Defines for three OPA differential amplifier example, must use OPA0, 1, and 2
#define DIFF3_POS0      opaPosSelAPORT2XCH9     // PC9
#define DIFF3_POS1      opaPosSelAPORT1XCH10    // PC10
#define DIFF3_RESSEL0   opaResSelR2eq3R1        // R2 = 3 * R1
#define DIFF3_RESSEL1   opaResSelR2eq0_33R1     // R2 = 1/3 * R1
#define DIFF3_OUT       opaOutModeAPORT1YCH11   // PC11     
#define DIFF3_ALTMASK   0                       // Don't use
#endif
        
#else
#error "opamp_config.h: PART NUMBER undefined"
#endif
#endif // OPAMP_CONFIG_H
