/**************************************************************************//**
 * @file loader.c
 * @brief USB/USART0 bootloader 1. level loader.
 * @author Silicon Labs
 * @version 1.22
 ******************************************************************************
 * @section License
 * <b>Copyright 2015 Silicon Laboratories, Inc. http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#include <string.h>
#include <stdbool.h>
#include "em_device.h"
#include "boot.h"

const
#if defined( EFM32GG990F1024 )
#include "loader-giant.h"
#elif defined( EFM32LG990F256 )
#include "loader-leopard.h"
#elif defined( _EZR32_LEOPARD_FAMILY )
#include "loader-ezrleopard.h"
#elif defined( _EFM32_WONDER_FAMILY )
#include "loader-wonder.h"
#endif

/**************************************************************************//**
 * The main entry point.
 *****************************************************************************/
int main(void)
{
  __set_MSP( ( 0x20000000 + sizeof( bootloader ) + 0x400 ) & 0xFFFFFFF0 );

  /* Load the entire bootloader into SRAM. */
  memcpy( (void*)0x20000000, bootloader, sizeof( bootloader ) );

  /* Start executing the bootloader. */
  BOOT_jump( *(uint32_t*)0x20000000, *(uint32_t*)0x20000004 );
}
