/***************************************************************************//**
 * @file usbconfig.h
 * @brief USB protocol stack library, application supplied configuration options.
 * @author Silicon Labs
 * @version 1.22
 ******************************************************************************
 * @section License
 * <b>Copyright 2015 Silicon Laboratories, Inc. http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef __USBCONFIG_H
#define __USBCONFIG_H

#include "config.h"

#ifdef __cplusplus
extern "C" {
#endif

#define USB_DEVICE

#define USB_CORECLK_HFRCO   // Devices supporting crystal-less USB can use
                            // HFRCO as core clock, default is HFXO
#define USB_USBC_32kHz_CLK  USB_USBC_32kHz_CLK_LFRCO

/****************************************************************************
**                                                                         **
** Specify number of endpoints used (in addition to EP0).                  **
**                                                                         **
*****************************************************************************/
#define NUM_EP_USED 3

/****************************************************************************
**                                                                         **
** Specify number of application timers you need.                          **
**                                                                         **
*****************************************************************************/
#define NUM_APP_TIMERS 0

/****************************************************************************
**                                                                         **
** Configure serial port debug output.                                     **
**                                                                         **
*****************************************************************************/

#if defined( BL_DEBUG )
  /* Define a function for transmitting a single char on the serial port. */
  extern int RETARGET_WriteChar(char c);
  #define USER_PUTCHAR  RETARGET_WriteChar

  /* Debug USB API functions (illegal input parameters etc.) */
  #define DEBUG_USB_API

  /* Include the printf function. */
  #define USB_USE_PRINTF
#endif

#ifdef __cplusplus
}
#endif

#endif /* __USBCONFIG_H */
