/*
 * memlcd.h
 *
 *  Created on: May 3, 2012
 *      Author: d.bruyn
 */

#ifndef MEMLCD_H_
#define MEMLCD_H_

#include "em_gpio.h"
#include "em_cmu.h"

typedef uint32_t   EMSTATUS;

#define MEMLCD_SIZE_Y   128
#define MEMLCD_SIZE_X   128

#define MEMLCD_CMD_UPDATE                 0x01
#define MEMLCD_CMD_ALL_CLEAR              0x04


#define MEMLCD_OK 0x00000000


typedef struct _MEMLCD_Pin
{
  GPIO_Port_TypeDef port;
  unsigned int      pin;
} MEMLCD_Pin;

typedef enum _MEMLCD_Mode {
  memlcdMode_Extcom,
  memlcdMode_Serial
} MEMLCD_Mode;

typedef struct _MEMLCD_Config
{
   /* GPIO connections */
  MEMLCD_Pin sclk;
  MEMLCD_Pin si;
  MEMLCD_Pin scs;
  MEMLCD_Pin extcomin;
  MEMLCD_Pin disp;
  MEMLCD_Pin extmode;

  /* USART module */
  CMU_Clock_TypeDef usartClock;
  USART_TypeDef     *usart;
  unsigned int      usartLocation;

  /* TIMER module used for precise timing */
  CMU_Clock_TypeDef timerClock;
  TIMER_TypeDef     *timer;

  /* Operational mode */
  MEMLCD_Mode mode;

  /* Enable when done */
  bool enable;
} MEMLCD_Config;



typedef struct _RowLimits
{
  uint8_t min;
  uint8_t max;
} RowLimits;


#define MEMLCD_CONFIG_STK3700_EXPBOARD   \
{  {gpioPortD, 2},   /* sclk */           \
   {gpioPortD, 0},   /* si   */           \
   {gpioPortD, 3},   /* scs  */           \
   {gpioPortC, 4},  /* extcomin */       \
   {gpioPortD, 5},  /* disp */           \
   {gpioPortD, 4},  /* extmode */        \
   cmuClock_USART1,  /* usartClock */     \
   USART1,           /* usart */          \
   USART_ROUTE_LOCATION_LOC1, /* usartLocation */  \
   cmuClock_TIMER0,  /* timerClock */     \
   TIMER0,           /* timer */          \
   memlcdMode_Extcom,/* mode */           \
   true              /* enable */         \
}


EMSTATUS MEMLCD_Init(MEMLCD_Config *cfg);
void MEMLCD_Enable( bool enable );
void MEMLCD_ComInv( void );
void MEMLCD_Clear( void );
EMSTATUS MEMLCD_Update(uint16_t *data, int firstLine, int lastLine);


void MEMLCD_CreateTestFrameBufferDMA(void);
EMSTATUS MEMLCD_Update_DMA( uint8_t firstline, uint8_t lastline );

#endif /* MEMLCD_H_ */
