/**************************************************************************//**
 * @file
 * @brief USB MSD Host Bootloader Configuration.
 *    This file defines how the bootloader is set up.
 * @author Energy Micro AS
 * @version 1.02
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2012 Energy Micro AS, http://www.energymicro.com</b>
 ******************************************************************************
 *
 * This source code is the property of Energy Micro AS. The source and compiled
 * code may only be used on Energy Micro "EFM32" microcontrollers.
 *
 * This copyright notice may not be removed from the source code nor changed.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Energy Micro AS has no
 * obligation to support this Software. Energy Micro AS is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Energy Micro AS will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/
#ifndef CONFIG_H
#define CONFIG_H

/* Timeout in second for USB flash drive plug-in */
#define USB_WAIT_TIMEOUT      2

/* The size of the bootloader flash image */
#define BOOTLOADER_SIZE       (16*1024)         /* 16 KB */

/* The maximum flash size of any EFM32 part */
#define MAX_SIZE_OF_FLASH     (1024*1024)       /* 1 MB */

/* The size of a mass erase block */
#define MASSERASE_BLOCK_SIZE  (512*1024)        /* 512 KB */  

/* Buffer size for flash write */
#define BUFFERSIZE            (4*1024)          /* 4 KB */

/* Text file with binary file name */
#define TEXT_FILENAME         "binfname.txt"

/* Default binary file for firmware upgrade if default text file is not found */
#define BIN_FILENAME          "efmimage.bin"

/* Remove debug output function if NOUART is defined */
#ifdef NOUART
#define printf(...)
#endif

#endif
