/**************************************************************************//**
 * @file
 * @brief USART for bootloader debugging
 * @author Energy Micro AS
 * @version 1.02
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2012 Energy Micro AS, http://www.energymicro.com</b>
 ******************************************************************************
 *
 * This source code is the property of Energy Micro AS. The source and compiled
 * code may only be used on Energy Micro "EFM32" microcontrollers.
 *
 * This copyright notice may not be removed from the source code nor changed.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Energy Micro AS has no
 * obligation to support this Software. Energy Micro AS is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Energy Micro AS will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/
#include "em_device.h"
#include "usart.h"

/**************************************************************************//**
 * @brief Transmit buffer to USART
 * @param Data character to transmit
 * @return Character sent
 *****************************************************************************/
int RETARGET_WriteChar(char c)
{
  /* Add CR if \n */
  if (c == '\n')
  {
    while (!(USART_USED->STATUS & USART_STATUS_TXBL))
      ;
    USART_USED->TXDATA = '\r';
  }
  while (!(USART_USED->STATUS & USART_STATUS_TXBL))
    ;
  USART_USED->TXDATA = c;

  return c;
}

/**************************************************************************//**
 * @brief Dummy function for retargetio.c
 *****************************************************************************/
int RETARGET_ReadChar(void)
{
  int i = 0;

  return i;
}
