/**************************************************************************//**
 * @file
 * @brief USART for bootloader debugging
 * @author Energy Micro AS
 * @version 1.02
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2012 Energy Micro AS, http://www.energymicro.com</b>
 ******************************************************************************
 *
 * This source code is the property of Energy Micro AS. The source and compiled
 * code may only be used on Energy Micro "EFM32" microcontrollers.
 *
 * This copyright notice may not be removed from the source code nor changed.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Energy Micro AS has no
 * obligation to support this Software. Energy Micro AS is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Energy Micro AS will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/
#ifndef __USART_H
#define __USART_H

#include <stdint.h>
#include "config.h"

#ifndef GG_STK
#define USART_BAUD      0x1900
#define USART_USED      UART1
#define USART_CLK       CMU_HFPERCLKEN0_UART1
#define USART_PORTNUM   1
#define USART_TXPORT    gpioPortB
#define USART_TXPIN     9
#define USART_LOCATION  USART_ROUTE_LOCATION_LOC2
#else
#define USART_BAUD      0x1900
#define USART_USED      USART0
#define USART_CLK       CMU_HFPERCLKEN0_USART0
#define USART_PORTNUM   2
#define USART_TXPORT    gpioPortC
#define USART_TXPIN     0
#define USART_LOCATION  USART_ROUTE_LOCATION_LOC5
#endif

#endif
