/***************************************************************************//**
 * @file
 * @brief SPEEX codec configuration
 * @author Energy Micro AS
 * @version 1.04
 *******************************************************************************
 * @section License
 * <b>(C) Copyright 2013 Energy Micro AS, http://www.energymicro.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 * 4. The source and compiled code may only be used on Energy Micro "EFM32"
 *    microcontrollers and "EFR4" radios.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Energy Micro AS has no
 * obligation to support this Software. Energy Micro AS is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Energy Micro AS will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/
#ifndef __CONFIG_H
#define __CONFIG_H

/* Giant Gecko WB decoder configuration file */

#ifdef __IAR_SYSTEMS_ICC__     /* IAR Compiler */
#define inline inline
#endif

#ifdef  __CC_ARM               /* ARM Compiler */
#define inline __inline
#endif

#define EXPORT 

#define FIXED_POINT
#define DISABLE_FLOAT_API
#define DISABLE_VBR
#define DISABLE_NOTIFICATIONS
#define DISABLE_WARNINGS
#define RELEASE
#define OVERRIDE_SPEEX_PUTC
#define OVERRIDE_SPEEX_FATAL
#define MAX_CHARS_PER_FRAME (106/BYTES_PER_CHAR)

#define NB_DEC_STACK    1500
#define SB_DEC_STACK    1500

#define SAMPLE_SIZE     320

/* NB */
#define FRAME_SIZE_8K   20
#define FRAME_SIZE_11K  28
#define FRAME_SIZE_15K  38
#define FRAME_SIZE_18K2 46
#define FRAME_SIZE_24K6 62

/* WB */
#define FRAME_SIZE_9K8  25
#define FRAME_SIZE_12K8 32
#define FRAME_SIZE_16K8 42
#define FRAME_SIZE_20K6 52
#define FRAME_SIZE_23K8	60
#define FRAME_SIZE_27K8	70
#define FRAME_SIZE_34K2	86
#define FRAME_SIZE_42K2	106

#define NARROWBAND8K    0
#define NARROWBAND      1
#define WIDEBAND        2
#define ULTRAWIDEBAND   3
#define NB8KCODEC       4

#define SPEEX_BAND      WIDEBAND

/* Address for DMA primary and alternate channel control data structure */
#define PRI_ADDRESS     0x20001000
#define ALT_ADDRESS     0x20001100

/* HFXO crystal frequency */
#define SPEEX_HFXO_FREQ 48000000

/* Define play list size */
#define LIST_SIZE       10

/* Configure DAC channel */
#define DAC_CHANNEL     0
#define DAC_CHDATA      CH0DATA
#define DAC_CHDMA       DMAREQ_DAC0_CH0
#define DAC_CHCTRL      CH0CTRL
#define DAC_CHCTRLEN    DAC_CH0CTRL_EN
#define DAC_CHPRSEN     DAC_CH0CTRL_PRSEN

#define DAC_PRS_CH      0
#define DAC_PRS_SEL     dacPRSSELCh0
#define DAC_CLOCK       1000000
#define REF_SELECT      0

/* Configure Timer */
#define TIMER_USED      TIMER1
#define TIMER_CLK       CMU_HFPERCLKEN0_TIMER1
#define TIMER_PRS       PRS_CH_CTRL_SOURCESEL_TIMER1
#define TIMER_SRC       PRS_CH_CTRL_SIGSEL_TIMER1OF

#define SAMPLE_8K       999
#define SAMPLE_16K      499
#define BASE_FREQ       8000000

extern void _speex_fatal(const char *str, const char *file, int line);
extern void _speex_putc(int ch, void *file);

#endif
