/***************************************************************************//**
 * @file
 * @brief Setup ADC for audio input
 * @author Energy Micro AS
 * @version 1.04
 *******************************************************************************
 * @section License
 * <b>(C) Copyright 2013 Energy Micro AS, http://www.energymicro.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 * 4. The source and compiled code may only be used on Energy Micro "EFM32"
 *    microcontrollers and "EFR4" radios.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Energy Micro AS has no
 * obligation to support this Software. Energy Micro AS is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Energy Micro AS will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/
#include "em_adc.h"
#include "config.h"

/***************************************************************************//**
 * @brief
 *   Configure ADC usage for this application.
 *******************************************************************************/
void initAdc(void)
{
  ADC_Init_TypeDef init = ADC_INIT_DEFAULT;
  ADC_InitSingle_TypeDef singleInit = ADC_INITSINGLE_DEFAULT;
  
  /* Init common issues for both single and scan mode */
  /* TIMERBASE should be set >= 1us for ADC warmup */
  /* When HFPERCLK is running at 48MHz, the maximum TIMERBASE */
  /* is (0x1f + 1) x 1/48M = 6.67us, less (1 - 0.67) = 0.33us if VDD as ref */
  /* If using internal ref, 6 x 0.67us = 4us, less (6 - 4) = 2us */
  /* Use acquisition time in channel configuration to compensate TIMEBASE */ 
  init.ovsRateSel = adcOvsRateSel16; 
  init.prescale = ADC_PrescaleCalc(ADC_CLOCK, 0);
  ADC_Init(ADC0, &init);

  /* Init for single conversion use, enable PRS channel for ADC */
  /* Default reference voltage is 1.25V */
  /* Internal ref, compensate 2us = 24 ADC clock + 1 = 25 minimum */
  singleInit.acqTime = adcAcqTime32;
#if ADC_REF_SELECT == 1
  /* Set reference voltage to 2.5V */
  singleInit.reference = adcRef2V5;
#elif ADC_REF_SELECT == 2
  /* Set reference voltage to VDD */
  singleInit.reference = adcRefVDD;
  /* VDD ref, compensate 0.33us = 4 ADC clock + 1 = 5 minimum */
  singleInit.acqTime = adcAcqTime8;
#endif
  singleInit.prsSel = ADC_PRS_SEL;
  singleInit.leftAdjust = true;
  singleInit.input = ADC_CHANNEL;
#if ADC_OVS_16 == 1
  /* Use oversampling to 16 bit resolution */
  singleInit.resolution = adcResOVS;
#endif
  
  ADC_InitSingle(ADC0, &singleInit);
}
