/**************************************************************************//**
 * @file
 * @brief Setup core and peripheral clocks for Speex Codec
 * @author Energy Micro AS
 * @version 1.04
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2013 Energy Micro AS, http://www.energymicro.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 * 4. The source and compiled code may only be used on Energy Micro "EFM32"
 *    microcontrollers and "EFR4" radios.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Energy Micro AS has no
 * obligation to support this Software. Energy Micro AS is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Energy Micro AS will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/
#include "em_cmu.h"
#include "clock.h"
#include "config.h"

/**************************************************************************//**
 * @brief Clock setup
 * Setup low/high frequency core clock and peripheral clocks 
 *****************************************************************************/
void initClock(void)
{
  /* Setup crystal frequency */
  SystemHFXOClockSet(SPEEX_HFXO_FREQ);   
  /* Use HFXO as core clock frequency */
  CMU_ClockSelectSet(cmuClock_HF, cmuSelect_HFXO);
  /* Disable HFRCO */
  CMU_OscillatorEnable(cmuOsc_HFRCO, false, false);

#if SPEEX_HFXO_FREQ == FREQ8M
#if SPEEX_BAND > NARROWBAND
#error CODEC or WIDEBAND or ULTRAWIDEBAND cannot run on 8MHz crystal 
#endif
  
#elif SPEEX_HFXO_FREQ == FREQ16M
#if SPEEX_BAND > WIDEBAND
#error CODEC or ULTRAWIDEBAND cannot run on 16MHz crystal 
#endif
  
#elif SPEEX_HFXO_FREQ == FREQ48M
  /* Scale the HFCLK to lower frequency, reset LE to DIV2 and HFLE to 0 */
#if SPEEX_BAND < WIDEBAND
  CMU_ClockDivSet(cmuClock_HF, 6);
  CMU->CTRL &= ~_CMU_CTRL_HFLE_MASK;
  CMU->HFCORECLKDIV = _CMU_HFCORECLKDIV_RESETVALUE;
#elif SPEEX_BAND < ULTRAWIDEBAND
  CMU_ClockDivSet(cmuClock_HF, 3);
  CMU->CTRL &= ~_CMU_CTRL_HFLE_MASK;
  CMU->HFCORECLKDIV = _CMU_HFCORECLKDIV_RESETVALUE;
#endif    
  
#elif SPEEX_HFXO_FREQ == FREQ32M
  /* Scale the HFCLK to lower frequency */
#if SPEEX_BAND < WIDEBAND
  CMU_ClockDivSet(cmuClock_CORE, cmuClkDiv_4);
  CMU_ClockDivSet(cmuClock_HFPER, cmuClkDiv_4);
#elif SPEEX_BAND < ULTRAWIDEBAND
  CMU_ClockDivSet(cmuClock_CORE, cmuClkDiv_2);
  CMU_ClockDivSet(cmuClock_HFPER, cmuClkDiv_2);
#else
#error CODEC or ULTRAWIDEBAND cannot run on 32MHz crystal 
#endif
#endif
  
  /* Enable clock for DMA */
  CMU->HFCORECLKEN0 |= CMU_HFCORECLKEN0_DMA;
  
  /* Enable clock for Peripherals */
#if SPEEX_BAND < NB8KCODEC
  CMU->HFPERCLKEN0 |= CMU_HFPERCLKEN0_DAC0 + CMU_HFPERCLKEN0_GPIO + CMU_HFPERCLKEN0_PRS + TIMER_CLK;
#else
  CMU->HFPERCLKEN0 |= CMU_HFPERCLKEN0_ADC0 + CMU_HFPERCLKEN0_DAC0 + CMU_HFPERCLKEN0_GPIO + CMU_HFPERCLKEN0_PRS + TIMER_CLK;
#endif
}
