/**************************************************************************//**
 * @file
 * @brief Setup DAC for audio output
 * @author Energy Micro AS
 * @version 1.04
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2013 Energy Micro AS, http://www.energymicro.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 * 4. The source and compiled code may only be used on Energy Micro "EFM32"
 *    microcontrollers and "EFR4" radios.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Energy Micro AS has no
 * obligation to support this Software. Energy Micro AS is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Energy Micro AS will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/
#include "em_dac.h"
#include "config.h"

/***************************************************************************//**
 * @brief
 *   Configure DAC usage for this application.
 *******************************************************************************/
void initDac(void)
{
  /* Use default settings */
  DAC_Init_TypeDef init = DAC_INIT_DEFAULT;
  DAC_InitChannel_TypeDef initChannel = DAC_INITCHANNEL_DEFAULT;

  /* Default reference voltage is 1.25V */
#if DAC_REF_SELECT == 1
  /* Set reference voltage to 2.5V */
  init.reference = dacRef2V5;
#elif DAC_REF_SELECT == 2
  /* Set reference voltage to VDD */
  init.reference = dacRefVDD;
#endif
  
  /* Calculate the DAC clock prescaler value that will result in a DAC clock
   * close to DAC_CLOCK. Second parameter is zero, if the HFPERCLK value is 0, the
   * function will check what the HFPERCLK actually is. */
  init.prescale = DAC_PrescaleCalc(DAC_CLOCK, 0);
  
  /* Initialize the DAC. */
  DAC_Init(DAC0, &init);

  /* Enable PRS CH to trigger samples at the right time with the timer */
  initChannel.prsSel = DAC_PRS_SEL;

  /* Initialize DAC channel */
  DAC_InitChannel(DAC0, &initChannel, DAC_CHANNEL);
}
