/**************************************************************************//**
 * @file
 * @brief Setup DMA for ADC, DAC and FLASH write
 * @author Energy Micro AS
 * @version 1.04
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2013 Energy Micro AS, http://www.energymicro.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 * 4. The source and compiled code may only be used on Energy Micro "EFM32"
 *    microcontrollers and "EFR4" radios.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Energy Micro AS has no
 * obligation to support this Software. Energy Micro AS is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Energy Micro AS will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/
#ifndef __DMA_H
#define __DMA_H

#include "config.h"

#define SRC_INC8_DST_INC8     0x00000000
#define SRC_FIX_DST_INC8      0x0c000000
#define SRC_INC8_DST_FIX      0xc0000000
#define SRC_FIX_DST_FIX_8     0xcc000000
#define SRC_INC16_DST_INC16   0x55000000
#define SRC_FIX_DST_INC16     0x5d000000
#define SRC_INC16_DST_FIX     0xd5000000
#define SRC_FIX_DST_FIX_16    0xdd000000
#define SRC_INC32_DST_INC32   0xaa000000
#define SRC_FIX_DST_INC32     0xae000000
#define SRC_INC32_DST_FIX     0xea000000
#define SRC_FIX_DST_FIX_32    0xee000000

#if SPEEX_BAND < NB8KCODEC
#define DMA_CHANNEL_NUMBER      1
#define DMA_ALT_CHANNEL_NUMBER  1
#define DMA_CHANNEL_DAC         0
#define DMA_CHANNEL_DACMASK     0x01
#else
#define DMA_CHANNEL_NUMBER      3
#define DMA_ALT_CHANNEL_NUMBER  2
#define DMA_CHANNEL_DAC         0
#define DMA_CHANNEL_ADC         1
#define DMA_CHANNEL_FLASH       2
#define DMA_CHANNEL_DACMASK     0x01
#define DMA_CHANNEL_ADCMASK     0x02
#define DMA_CHANNEL_FLHMASK     0x04
#endif

#define ADC_PP_START  SRC_FIX_DST_INC16 + ((SAMPLE_SIZE - 1) << _DMA_CTRL_N_MINUS_1_SHIFT) + DMA_CTRL_CYCLE_CTRL_PINGPONG;
#define FLASH_WR_START  SRC_INC32_DST_FIX + ((FLASH_WORD_SIZE - 2) << _DMA_CTRL_N_MINUS_1_SHIFT) + DMA_CTRL_CYCLE_CTRL_BASIC;

void initDma(void);
void initAdcDma(void);
void startAdcDma(void);
void stopAdcDma(void);
void initFlashDma(void);
void startFlashDma(void);
void initDacDma(void);
void startDacDma(uint16_t bufferSize);
void stopDacDma(void);

#endif
