/**************************************************************************//**
 * @file uartdrv_flow_control.h
 * @brief UART Flow Control Header File
 * @author Silicon Labs
 * @version  1.04

 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2017 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/
#ifndef __UARTDRV_FLOW_CONTROL_H__
#define __UARTDRV_FLOW_CONTROL_H__

#include "em_gpio.h"
#include "uartdrv.h"
#include "bspconfig.h"

// UART flow control demo, includes hardware flow control, software flow control

#if (defined EFM32GG_STK3700) || (defined EFM32_Gxxx_STK) \
    || (defined EFM32LG_STK3600) || (defined EFM32WG_STK3800)
#define PB0_PORT   gpioPortB               // Pushbutton 0 port.
#define PB0_PIN    9                       // Pushbutton 0 pin.
#define PB1_PORT   gpioPortB               // Pushbutton 1 port.
#define PB1_PIN    10                      // Pushbutton 1 pin.

#elif (defined SLSTK3400A_EFM32HG) || (defined EFM32ZG_STK3200) \
    || (defined SLSTK3401A_EFM32PG) || (defined SLSTK3402A_EFM32PG12)
#define PB0_PORT   BSP_GPIO_PB0_PORT       // Pushbutton 0 port.
#define PB0_PIN    BSP_GPIO_PB0_PIN        // Pushbutton 0 pin.
#define PB1_PORT   BSP_GPIO_PB1_PORT       // Pushbutton 1 port.
#define PB1_PIN    BSP_GPIO_PB1_PIN        // Pushbutton 1 pin.

#elif defined (EFM32TG_STK3300)
#define PB0_PORT   gpioPortD               // Pushbutton 0 port.
#define PB0_PIN    8                       // Pushbutton 0 pin.
#define PB1_PORT   gpioPortB               // Pushbutton 1 port.
#define PB1_PIN    11                      // Pushbutton 1 pin.

#endif

#if defined ( SLSTK3400A_EFM32HG ) || (defined SLSTK3401A_EFM32PG) \
    || (defined SLSTK3402A_EFM32PG12)
#define USART_DEV       USART0
#define USART_BAUDRATE  115200
#else
#define USART_DEV       USART1
#define USART_BAUDRATE  115200
#endif

#if defined ( SLSTK3400A_EFM32HG )
#define USART_TX_PORT   gpioPortE
#define USART_TX_PIN    10
#define USART_RX_PORT   gpioPortE
#define USART_RX_PIN    11
#define USART_LOCATION  _USART_ROUTE_LOCATION_LOC0
#define USART_RTS_PORT  gpioPortE
#define USART_RTS_PIN   12
#define USART_CTS_PORT  gpioPortE
#define USART_CTS_PIN   13
#elif defined ( EFM32ZG_STK3200 )
#define USART_TX_PORT   gpioPortD
#define USART_TX_PIN    7
#define USART_RX_PORT   gpioPortD
#define USART_RX_PIN    6
#define USART_LOCATION  _USART_ROUTE_LOCATION_LOC3
#define USART_RTS_PORT  gpioPortC
#define USART_RTS_PIN   15
#define USART_CTS_PORT  gpioPortC
#define USART_CTS_PIN   14
#elif defined ( SLSTK3401A_EFM32PG ) ||  (defined SLSTK3402A_EFM32PG12)
#define USART_TX_PORT   gpioPortA
#define USART_TX_PIN    0
#define USART_RX_PORT   gpioPortA
#define USART_RX_PIN    1
#define USART_RTS_PORT  gpioPortC
#define USART_RTS_PIN   7
#define USART_CTS_PORT  gpioPortC
#define USART_CTS_PIN   6
#if defined( _USART_ROUTELOC0_MASK )
#define USART_TX_LOCATION _USART_ROUTELOC0_TXLOC_LOC0
#define USART_RX_LOCATION _USART_ROUTELOC0_RXLOC_LOC0
#endif
#if defined( _USART_ROUTELOC1_MASK )
#define USART_CTS_LOCATION _USART_ROUTELOC1_CTSLOC_LOC7
#define USART_RTS_LOCATION _USART_ROUTELOC1_RTSLOC_LOC7
#endif
#else
#define USART_TX_PORT   gpioPortD
#define USART_TX_PIN    0
#define USART_RX_PORT   gpioPortD
#define USART_RX_PIN    1
#define USART_LOCATION  _USART_ROUTE_LOCATION_LOC1
#define USART_RTS_PORT  gpioPortD
#define USART_RTS_PIN   2
#define USART_CTS_PORT  gpioPortD
#define USART_CTS_PIN   3
#endif

#define DEMO_NONE  0
#define NUMBER_OF_DEMOS   2

#if defined(SEGMENT_LCD)
#include "segmentlcd.h"
#define displayInit()   SegmentLCD_Init(false)
#define displayString(x)  SegmentLCD_Write(x)
#define displayOff()    SegmentLCD_Disable()
#define LCD_STR_LEN       6

#elif defined(TFT_LCD)
#include "display.h"
#include "textdisplay.h"
#include "retargettextdisplay.h"
#include <stdio.h>
extern DISPLAY_Device_t displayDevice;

#define displayInit()   DISPLAY_Init(); RETARGET_TextDisplayInit()
#define displayString(x)  printf(TEXTDISPLAY_ESC_SEQ_CURSOR_HOME_VT100); \
  printf("\n  Flow Control" \
         "\n  Demo(UARTDRV)" \
         "\n\n\n  Push BTN1 to\n" \
         "  cycle modes\n" \
         "\n  Push BTN0 to\n" \
         "  start test \n\n\n\n"); \
  printf("  %s",x)
#define displayOff() DISPLAY_DeviceGet( 0, &displayDevice ); \
  displayDevice.pDisplayPowerOn(&displayDevice, false)
#define LCD_STR_LEN       20
#endif

#endif /* __UARTDRV_FLOW_CONTROL_H__ */
