/**************************************************************************//**
 * @file uart_flow_control_s1.h
 * @brief UART Flow Control Header File
 * @author Silicon Labs
 * @version  1.04

 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2017 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/
#ifndef __UART_FLOW_CONTROL_S1_H__
#define __UART_FLOW_CONTROL_S1_H__

#include "em_gpio.h"
#include "bspconfig.h"

// UART flow control demo, includes natively hardware flow control, software flow control

#define PB0_PORT   BSP_GPIO_PB0_PORT               // Pushbutton 0 port.
#define PB0_PIN    BSP_GPIO_PB0_PIN                // Pushbutton 0 pin.
#define PB1_PORT   BSP_GPIO_PB1_PORT               // Pushbutton 1 port.
#define PB1_PIN    BSP_GPIO_PB1_PIN                // Pushbutton 1 pin.

#define DEMO_NONE  0
#define NUMBER_OF_DEMOS   2
#define LCD_STR_LEN       20

#define USART_DEV      USART0
#define USART_CLOCK    cmuClock_USART0
#define USART_TX_IRQn  USART0_TX_IRQn
#define USART_RX_IRQn  USART0_RX_IRQn
#define USART_TX_IRQHANDLER  USART0_TX_IRQHandler
#define USART_RX_IRQHANDLER  USART0_RX_IRQHandler

#define USART_TX_PORT  gpioPortA
#define USART_TX_PIN   0
#define USART_RX_PORT  gpioPortA
#define USART_RX_PIN   1
#define USART_RTS_PORT gpioPortC
#define USART_RTS_PIN  7
#define USART_CTS_PORT gpioPortC
#define USART_CTS_PIN  6

#define USART_TX_LOCATION USART_ROUTELOC0_TXLOC_LOC0
#define USART_RX_LOCATION USART_ROUTELOC0_RXLOC_LOC0
#define USART_CTS_LOCATION USART_ROUTELOC1_CTSLOC_LOC7
#define USART_RTS_LOCATION USART_ROUTELOC1_RTSLOC_LOC7

__STATIC_INLINE void enableUsartTxblInt(void)
{
  // Enable TXBL interrupt
  USART_DEV->IEN |= USART_IEN_TXBL;
}

__STATIC_INLINE void disableUsartTxblInt(void)
{
  // Disable TXBL interrupt
  USART_DEV->IEN &= ~USART_IEN_TXBL;
}

typedef enum
{
  modeHWUART,
  modeSW
} UART_FC_Mode;

typedef struct
{
  // Selects the type of flow control
  UART_FC_Mode mode;

  // Callback function which is called when
  // the entire message has been sent.
  // If a callback is not used, this field MUST
  // be set to NULL.
  void (*txCallback)(void);

  // Callback function which is called for every byte received.
  // This MUST be defined
  void (*rxCallback)(uint8_t);

} UART_FC_Config_TypeDef;

#endif /* __UART_FLOW_CONTROL_S1_H__ */
