/**************************************************************************//**
 * @file aes_keys.c
 * @brief Contains the bootloader encryption keys
 * @author Silicon Labs
 * @version x.xx
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2014 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/

#include <stdint.h>
#include "em_device.h"

/* Give a compiler warning to remind users to replace this file with their own keys */
#warning "Using default aes_keys.c. Substitute this with your own keys!"

#if defined( _EFM32_GIANT_FAMILY )
uint8_t encryptionKey[]  = {0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32};
#elif defined( _EFM32_HAPPY_FAMILY )
uint8_t encryptionKey[]  = {0x00, 0x00, 0x00, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32, 0xef, 0x32};
#endif

uint8_t initVector[]     = {0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11};
uint8_t hashKey[]        = {0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22};
uint8_t hashInitVector[] = {0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33};
