/**************************************************************************//**
 * @file fortuna_entropy_accumulator.h
 * @brief Interface to entropy accumulator of the Fortuna PRNG.
 * @author Energy Micro AS
 * @version 1.02
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2013 Energy Micro AS, http://www.energymicro.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 * 4. The source and compiled code may only be used on Energy Micro "EFM32"
 *    microcontrollers and "EFR4" radios.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Energy Micro AS has no
 * obligation to support this Software. Energy Micro AS is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Energy Micro AS will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/

#ifndef __FORTUNA_ENTROPY_ACCUMULATOR_H
#define __FORTUNA_ENTROPY_ACCUMULATOR_H

/* FUNCTION Prototypes */

/* Initialize the entropy accumulator. */
void EA_Init (void);

/* Add random data to the entropy pools.*/
int  EA_AddRandomEvent (int       sourceId,
                        uint32_t  eventData);

/* Check if an entropy pools are ready with sufficient entropy data. */
bool EA_PoolReady      (int       poolId);

/* Returns a 32 bit data word from an entropy pool. */
uint32_t EA_PoolDataWordGet (int      poolId,
                             int      poolWord);

/* Produce a 32-bit hash from a data buffer of any size. */
uint32_t EA_JenkinsHash (uint8_t *buffer,
                         uint32_t nBytes);

#endif /*__FORTUNA_ENTACCUMULATOR_H*/
