/**************************************************************************//**
 * @file fortuna_prng.h
 * @brief Interface to core part of Fortuna PRNG.
 * @author Energy Micro AS
 * @version 1.02
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2013 Energy Micro AS, http://www.energymicro.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 * 4. The source and compiled code may only be used on Energy Micro "EFM32"
 *    microcontrollers and "EFR4" radios.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Energy Micro AS has no
 * obligation to support this Software. Energy Micro AS is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Energy Micro AS will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 *****************************************************************************/
#ifndef __FORTUNA_PRNG_H
#define __FORTUNA_PRNG_H

#define FORTUNA_KEY_SIZE                   (256) /* 256 bit key */

#define FORTUNA_SEED_SIZE  (FORTUNA_KEY_SIZE/32) /* Seed size in 32 bit words */
                                                         
typedef uint32_t FORTUNA_Seed_t [FORTUNA_SEED_SIZE];


/* FUNCTION Prototypes */

/* Get a new seed value from the entropy pools. */
int  PRNG_SeedGetFromPools(FORTUNA_Seed_t seed);

/* Reseed the PRNG. */
void PRNG_Reseed (FORTUNA_Seed_t seed);

/* Set key from the output of the generator itself. */
int PRNG_KeySetFromOutput(void);

/* Generate the specified amount of pseudo random data. */
int PRNG_RandomDataGet (void* randomData, int numBytes);

/* A function that clears the contents of the key. */
void PRNG_Clear(void);

#endif /*__FORTUNA_PRNG_H*/
