/**************************************************************************//**
 * @file main.c
 * @brief Start point of BLDC application
 * @author Silicon Labs
 * @version 0.00 (leave as is with x.xx, Correct version is automatically inserted by auto-generation)
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2014 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * DISCLAIMER OF WARRANTY/LIMITATION OF REMEDIES: Silicon Labs has no
 * obligation to support this Software. Silicon Labs is providing the
 * Software "AS IS", with no express or implied warranties of any kind,
 * including, but not limited to, any implied warranties of merchantability
 * or fitness for any particular purpose or warranties against infringement
 * of any proprietary rights of a third party.
 *
 * Silicon Labs will not be liable for any consequential, incidental, or
 * special damages, or any other relief, or for any claim by any third party,
 * arising from your use of this Software.
 *
 ******************************************************************************/
#include "em_device.h"
#include "em_chip.h"
#include "em_cmu.h"
#include "bsp.h"
#include "uart.h"
#include "motor.h"
#include "logging.h"
#include "pid.h"
#include "config.h"
extern bool isRunning;
void DBG_GPIO_Init(void);
/**********************************************************
 * Kit specific initialization. Enables access to the 
 * RS-232 connector. 
 *********************************************************/
volatile uint32_t msTicks = 0; /* counts 1ms timeTicks */
void SysTick_Handler(void)
{
  msTicks++;       /* increment counter necessary in Delay()*/
}
int main(void)
{   
  CHIP_Init();
  CMU_ClockSelectSet(cmuClock_HF, cmuSelect_HFXO);
  if (SysTick_Config(CMU_ClockFreqGet(cmuClock_CORE) / 1000)) while (1) ;
  kitInit();
  uartInit();
  LOG_INIT();

  /* State variables for the push buttons */
  uint16_t buttons;
  uint16_t lastButtons = 0xFFFF;
  uint16_t validButtons;
  bool released = false;
  ButtonInit();
  DBG_GPIO_Init();
  msTicks = 0;
  while (1)
  {
    /* Check if any of the push buttons are pressed 
	   For GG DK board, this called the BSP routine,
	   For HG STK board, this use PC9/PC pin */

    buttons = ButtonDetect();
    if ( buttons != lastButtons )
    {

      if (buttons != 0x0)
      {
        validButtons = buttons;
        msTicks = 0;
        released = 0;
      }
      else
      {
        released = 1;
      }
      lastButtons = buttons;

      if (released == 1)
      {
        if ( validButtons & 0x1 )
        {
          if(isRunning)
          {
            stopMotor();
          }
          else
          {
            setDirection(!getDirection());
          }
        }
        else if ( validButtons & 0x2 )
        {
          if (isRunning)
          {
            if (msTicks > 500)
            {
              speedDecrease();
            }
            else
            {
              speedIncrease();
            }
          }
          else
          {
            startMotor();
          }
        }

        msTicks = 0;
      }
    }
  }
}

void DBG_GPIO_Init(void)
{
#if defined (DEBUG_GPIO)
  GPIO_PinModeSet(DBG_GPIO_PORT1, DBG_GPIO_PIN1, gpioModePushPull, 0);
  GPIO_PinModeSet(DBG_GPIO_PORT2, DBG_GPIO_PIN2, gpioModePushPull, 0);
  GPIO_PinOutSet (DBG_GPIO_PORT1, DBG_GPIO_PIN1);
  GPIO_PinOutSet (DBG_GPIO_PORT2, DBG_GPIO_PIN2);
#endif
}
