var NAVTREE =
[
  [ "LUFA Library", "index.html", [
    [ "Source Code License", "_page__license_info.html", [
      [ "License Summary for Human Beings", "_page__license_info.html#Sec_LicenseForHumans", null ],
      [ "Commercial Licensing", "_page__license_info.html#Sec_CommercialLicenses", null ],
      [ "LUFA License Text", "_page__license_info.html#Sec_LicenseText", null ]
    ] ],
    [ "Donating to Support This Project", "_page__donating.html", null ],
    [ "Device and Hardware Support", "_page__device_support.html", "_page__device_support" ],
    [ "Project Changelog", "_page__change_log.html", [
      [ "Version 140302", "_page__change_log.html#Sec_ChangeLog140302", null ],
      [ "Version 130901", "_page__change_log.html#Sec_ChangeLog130901", null ],
      [ "Version 130303", "_page__change_log.html#Sec_ChangeLog130303", null ],
      [ "Version 120730", "_page__change_log.html#Sec_ChangeLog120730", null ],
      [ "Version 120219", "_page__change_log.html#Sec_ChangeLog120219", null ],
      [ "Version 111009", "_page__change_log.html#Sec_ChangeLog111009", null ],
      [ "Version 110528", "_page__change_log.html#Sec_ChangeLog110528", null ],
      [ "Version 101122", "_page__change_log.html#Sec_ChangeLog101122", null ],
      [ "Version 100807", "_page__change_log.html#Sec_ChangeLog100807", null ],
      [ "Version 100513", "_page__change_log.html#Sec_ChangeLog100513", null ],
      [ "Version 100219", "_page__change_log.html#Sec_ChangeLog100219", null ],
      [ "Version 091223", "_page__change_log.html#Sec_ChangeLog091223", null ],
      [ "Version 091122", "_page__change_log.html#Sec_ChangeLog091122", null ],
      [ "Version 090924", "_page__change_log.html#Sec_ChangeLog090924", null ],
      [ "Version 090810", "_page__change_log.html#Sec_ChangeLog090810", null ],
      [ "Version 090605", "_page__change_log.html#Sec_ChangeLog090605", null ],
      [ "Version 090510", "_page__change_log.html#Sec_ChangeLog090510", null ],
      [ "Version 090401", "_page__change_log.html#Sec_ChangeLog090401", null ],
      [ "Version 090209", "_page__change_log.html#Sec_ChangeLog090209", null ],
      [ "Version 081224", "_page__change_log.html#Sec_ChangeLog081224", null ],
      [ "Version 1.5.3 (081002)", "_page__change_log.html#Sec_ChangeLog153", null ],
      [ "Version 1.5.2 (080731)", "_page__change_log.html#Sec_ChangeLog152", null ],
      [ "Version 1.5.1 (080707)", "_page__change_log.html#Sec_ChangeLog151", null ],
      [ "Version 1.5.0 (080610)", "_page__change_log.html#Sec_ChangeLog150", null ],
      [ "Version 1.4.1 (090519)", "_page__change_log.html#Sec_ChangeLog141", null ],
      [ "Version 1.4.0 (090505)", "_page__change_log.html#Sec_ChangeLog140", null ],
      [ "Version 1.3.2 (080401)", "_page__change_log.html#Sec_ChangeLog132", null ],
      [ "Version 1.3.1 (080319)", "_page__change_log.html#Sec_ChangeLog131", null ],
      [ "Version 1.3.0 (080307)", "_page__change_log.html#Sec_ChangeLog130", null ],
      [ "Version 1.2.0 (080204)", "_page__change_log.html#Sec_ChangeLog120", null ],
      [ "Version 1.1.0 (080125)", "_page__change_log.html#Sec_ChangeLog110", null ]
    ] ],
    [ "Known Issues", "_page__known_issues.html", [
      [ "Version 140302", "_page__known_issues.html#Sec_KnownIssues140302", null ],
      [ "Version 130901", "_page__known_issues.html#Sec_KnownIssues130901", null ],
      [ "Version 130303", "_page__known_issues.html#Sec_KnownIssues130303", null ],
      [ "Version 120730", "_page__known_issues.html#Sec_KnownIssues120730", null ]
    ] ],
    [ "Future Changes", "_page__future_changes.html", null ],
    [ "Getting Started", "_page__getting_started.html", "_page__getting_started" ],
    [ "Developing With LUFA", "_page__developing_with_l_u_f_a.html", "_page__developing_with_l_u_f_a" ],
    [ "User Projects Powered by LUFA", "_page__l_u_f_a_powered_projects.html", [
      [ "AVR-USB Development Boards Using LUFA", "_page__l_u_f_a_powered_projects.html#Sec_BoardsUsingLUFA", null ],
      [ "Projects Using LUFA (Hobbyist)", "_page__l_u_f_a_powered_projects.html#Sec_LUFAProjects", null ],
      [ "Projects Using LUFA (Commercial)", "_page__l_u_f_a_powered_projects.html#Sec_LUFACommercialProjects", null ],
      [ "Publications Mentioning LUFA", "_page__l_u_f_a_powered_projects.html#Sec_LUFAPublications", null ],
      [ "Other Notable Mentions of LUFA", "_page__l_u_f_a_powered_projects.html#Sec_LUFANotableMentions", null ],
      [ "Non-Official LUFA Ports and Forks", "_page__l_u_f_a_powered_projects.html#Sec_PortsAndForks", null ]
    ] ],
    [ "Library Resources", "_page__resources.html", [
      [ "Unofficial Resources", "_page__resources.html#Sec_UnofficialResources", null ],
      [ "LUFA Related Webpages", "_page__resources.html#Sec_ProjectPages", null ],
      [ "Assistance With LUFA", "_page__resources.html#Sec_ProjectHelp", null ],
      [ "Latest In-Development Source Code", "_page__resources.html#Sec_InDevelopment", null ],
      [ "USB Resources", "_page__resources.html#Sec_USBResources", null ]
    ] ],
    [ "Modules", "modules.html", "modules" ],
    [ "Data Structures", null, [
      [ "Data Structures", "annotated.html", "annotated" ],
      [ "Data Structure Index", "classes.html", null ],
      [ "Data Fields", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Variables", "functions_vars.html", "functions_vars" ]
      ] ]
    ] ],
    [ "Files", null, [
      [ "File List", "files.html", "files" ],
      [ "Globals", "globals.html", [
        [ "All", "globals.html", "globals_dup" ],
        [ "Functions", "globals_func.html", "globals_func" ],
        [ "Variables", "globals_vars.html", null ],
        [ "Typedefs", "globals_type.html", null ],
        [ "Enumerations", "globals_enum.html", null ],
        [ "Enumerator", "globals_eval.html", "globals_eval" ],
        [ "Macros", "globals_defs.html", "globals_defs" ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"_a_d_c_8h.html",
"_l_u_f_a_config_8h.html",
"_s_p_i___x_m_e_g_a_8h.html",
"group___group___a_d_c___a_v_r8.html#ga2b67a00e1ff053d863d2e35cac6716b0",
"group___group___board_info___a3_b_u___x_p_l_a_i_n_e_d.html#ga0091c5126d848d3d0c962d11156700cc",
"group___group___board_types.html#ga235e80e3df3f6122dc4d951c5246e06b",
"group___group___common.html#gaacc3ee1a7f283f8ef65cea31f4436a95",
"group___group___dataflash___s_t_k526.html#gad1b7d12f3253593627d85b06636748a2",
"group___group___endpoint_management___a_v_r8.html#gab38cc206d86c2850741bd4f0b0ef69bf",
"group___group___endpoint_primitive_r_w___e_f_m32_g_g.html#ga35e3dd3a468a294b2d0fd914ff373036",
"group___group___endpoint_r_w___x_m_e_g_a.html#ggaa42b7eb8d1be3afadb97097bf2605740ac395cfec6ba73cd76fd016e746b7dc74",
"group___group___h_i_d_parser.html#ga54fce56b18e19489edcdb3155116a995",
"group___group___host___u_c3_b.html#gga647b09a2205a9beda86049b6b8f004a0ad4e5a60748230db93193081b06e61a06",
"group___group___l_e_ds___e_v_k1100.html#ga067978238d36887c2c33d74e69f90bce",
"group___group___l_e_ds___u_c3_a3___x_p_l_a_i_n_e_d.html#gab03d373544b1782a0dcb43968fe84db9",
"group___group___pipe_management___u_c3.html#ga7a6d8ba3de41d5a35b04cc91c4a27cb7",
"group___group___platform_drivers___u_c3_clocks.html",
"group___group___serial___a_v_r8.html#gac4cce6530db958efa710be799994f4f9",
"group___group___t_w_i___a_v_r8.html#gabe8c57b6ff6eb85847b23e3661db77e0",
"group___group___u_s_b_class_audio_common.html#ga120975b09b744cf4e05b554f32815de7",
"group___group___u_s_b_class_c_d_c_common.html#gaee2d8540f3eb477f6700244215bd8f59",
"group___group___u_s_b_class_h_i_d_common.html#ga3587d53740922f8cd47a77a41469b535",
"group___group___u_s_b_class_h_i_d_common.html#gabd7bf746f597db6306eefb131a3a6b7b",
"group___group___u_s_b_class_m_i_d_i_common.html#gac72619e21a53fc07fd1f411c4523697a",
"group___group___u_s_b_class_printer_device.html#gaf95359e267da1bd928ffe6bb3ffd06a1",
"group___group___u_s_b_class_s_i_common.html#ga741351fc4ce55873755f2e2fe4359d63",
"group___group___u_s_b_mode.html#gaa04ce57b94fcb692be8c0c7119836ac5",
"struct_u_s_b___audio___descriptor___interface___a_c__t.html#adbd1a28261d4db06a025ac5226c184e0",
"struct_u_s_b___class_info___p_r_n_t___host__t.html#aeb2c8cec6c9a346e56b6ade6248a4f1e",
"struct_u_s_b___std_descriptor___interface__t.html#aaa9ca8e26d78ba15a89dee4ce04edacd"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';
var navTreeSubIndices = new Array();

function getData(varName)
{
  var i = varName.lastIndexOf('/');
  var n = i>=0 ? varName.substring(i+1) : varName;
  return eval(n.replace(/\-/g,'_'));
}

function stripPath(uri)
{
  return uri.substring(uri.lastIndexOf('/')+1);
}

function stripPath2(uri)
{
  var i = uri.lastIndexOf('/');
  var s = uri.substring(i+1);
  var m = uri.substring(0,i+1).match(/\/d\w\/d\w\w\/$/);
  return m ? uri.substring(i-6) : s;
}

function hashValue()
{
  return $(location).attr('hash').substring(1).replace(/[^\w\-]/g,'');
}

function hashUrl()
{
  return '#'+hashValue();
}

function pathName()
{
  return $(location).attr('pathname').replace(/[^-A-Za-z0-9+&@#/%?=~_|!:,.;\(\)]/g, '');
}

function localStorageSupported()
{
  try {
    return 'localStorage' in window && window['localStorage'] !== null && window.localStorage.getItem;
  }
  catch(e) {
    return false;
  }
}


function storeLink(link)
{
  if (!$("#nav-sync").hasClass('sync') && localStorageSupported()) {
      window.localStorage.setItem('navpath',link);
  }
}

function deleteLink()
{
  if (localStorageSupported()) {
    window.localStorage.setItem('navpath','');
  }
}

function cachedLink()
{
  if (localStorageSupported()) {
    return window.localStorage.getItem('navpath');
  } else {
    return '';
  }
}

function getScript(scriptName,func,show)
{
  var head = document.getElementsByTagName("head")[0]; 
  var script = document.createElement('script');
  script.id = scriptName;
  script.type = 'text/javascript';
  script.onload = func; 
  script.src = scriptName+'.js'; 
  if ($.browser.msie && $.browser.version<=8) { 
    // script.onload does not work with older versions of IE
    script.onreadystatechange = function() {
      if (script.readyState=='complete' || script.readyState=='loaded') { 
        func(); if (show) showRoot(); 
      }
    }
  }
  head.appendChild(script); 
}

function createIndent(o,domNode,node,level)
{
  var level=-1;
  var n = node;
  while (n.parentNode) { level++; n=n.parentNode; }
  if (node.childrenData) {
    var imgNode = document.createElement("img");
    imgNode.style.paddingLeft=(16*level).toString()+'px';
    imgNode.width  = 16;
    imgNode.height = 22;
    imgNode.border = 0;
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() {
      if (node.expanded) {
        $(node.getChildrenUL()).slideUp("fast");
        node.plus_img.src = node.relpath+"ftv2pnode.png";
        node.expanded = false;
      } else {
        expandNode(o, node, false, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
    imgNode.src = node.relpath+"ftv2pnode.png";
  } else {
    var span = document.createElement("span");
    span.style.display = 'inline-block';
    span.style.width   = 16*(level+1)+'px';
    span.style.height  = '22px';
    span.innerHTML = '&#160;';
    domNode.appendChild(span);
  } 
}

var animationInProgress = false;

function gotoAnchor(anchor,aname,updateLocation)
{
  var pos, docContent = $('#doc-content');
  var ancParent = $(anchor.parent());
  if (ancParent.hasClass('memItemLeft') ||
      ancParent.hasClass('fieldname') ||
      ancParent.hasClass('fieldtype') ||
      ancParent.is(':header'))
  {
    pos = ancParent.position().top;
  } else if (anchor.position()) {
    pos = anchor.position().top;
  }
  if (pos) {
    var dist = Math.abs(Math.min(
               pos-docContent.offset().top,
               docContent[0].scrollHeight-
               docContent.height()-docContent.scrollTop()));
    animationInProgress=true;
    docContent.animate({
      scrollTop: pos + docContent.scrollTop() - docContent.offset().top
    },Math.max(50,Math.min(500,dist)),function(){
      if (updateLocation) window.location.href=aname;
      animationInProgress=false;
    });
  }
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  node.expanded = false;
  a.appendChild(node.label);
  if (link) {
    var url;
    if (link.substring(0,1)=='^') {
      url = link.substring(1);
      link = url;
    } else {
      url = node.relpath+link;
    }
    a.className = stripPath(link.replace('#',':'));
    if (link.indexOf('#')!=-1) {
      var aname = '#'+link.split('#')[1];
      var srcPage = stripPath(pathName());
      var targetPage = stripPath(link.split('#')[0]);
      a.href = srcPage!=targetPage ? url : "javascript:void(0)"; 
      a.onclick = function(){
        storeLink(link);
        if (!$(a).parent().parent().hasClass('selected'))
        {
          $('.item').removeClass('selected');
          $('.item').removeAttr('id');
          $(a).parent().parent().addClass('selected');
          $(a).parent().parent().attr('id','selected');
        }
        var anchor = $(aname);
        gotoAnchor(anchor,aname,true);
      };
    } else {
      a.href = url;
      a.onclick = function() { storeLink(link); }
    }
  } else {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() {
    if (!node.childrenUL) {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  (function (){ // retry until we can scroll to the selected item
    try {
      var navtree=$('#nav-tree');
      navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
    } catch (err) {
      setTimeout(arguments.callee, 0);
    }
  })();
}

function expandNode(o, node, imm, showRoot)
{
  if (node.childrenData && !node.expanded) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        expandNode(o, node, imm, showRoot);
      }, showRoot);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      } if (imm || ($.browser.msie && $.browser.version>8)) { 
        // somehow slideDown jumps to the start of tree for IE9 :-(
        $(node.getChildrenUL()).show();
      } else {
        $(node.getChildrenUL()).slideDown("fast");
      }
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
    }
  }
}

function glowEffect(n,duration)
{
  n.addClass('glow').delay(duration).queue(function(next){
    $(this).removeClass('glow');next();
  });
}

function highlightAnchor()
{
  var aname = hashUrl();
  var anchor = $(aname);
  if (anchor.parent().attr('class')=='memItemLeft'){
    var rows = $('.memberdecls tr[class$="'+hashValue()+'"]');
    glowEffect(rows.children(),300); // member without details
  } else if (anchor.parent().attr('class')=='fieldname'){
    glowEffect(anchor.parent().parent(),1000); // enum value
  } else if (anchor.parent().attr('class')=='fieldtype'){
    glowEffect(anchor.parent().parent(),1000); // struct field
  } else if (anchor.parent().is(":header")) {
    glowEffect(anchor.parent(),1000); // section header
  } else {
    glowEffect(anchor.next(),1000); // normal member
  }
  gotoAnchor(anchor,aname,false);
}

function selectAndHighlight(hash,n)
{
  var a;
  if (hash) {
    var link=stripPath(pathName())+':'+hash.substring(1);
    a=$('.item a[class$="'+link+'"]');
  }
  if (a && a.length) {
    a.parent().parent().addClass('selected');
    a.parent().parent().attr('id','selected');
    highlightAnchor();
  } else if (n) {
    $(n.itemDiv).addClass('selected');
    $(n.itemDiv).attr('id','selected');
  }
  if ($('#nav-tree-contents .item:first').hasClass('selected')) {
    $('#nav-sync').css('top','30px');
  } else {
    $('#nav-sync').css('top','5px');
  }
  showRoot();
}

function showNode(o, node, index, hash)
{
  if (node && node.childrenData) {
    if (typeof(node.childrenData)==='string') {
      var varName    = node.childrenData;
      getScript(node.relpath+varName,function(){
        node.childrenData = getData(varName);
        showNode(o,node,index,hash);
      },true);
    } else {
      if (!node.childrenVisited) {
        getNode(o, node);
      }
      $(node.getChildrenUL()).css({'display':'block'});
      if (node.isLast) {
        node.plus_img.src = node.relpath+"ftv2mlastnode.png";
      } else {
        node.plus_img.src = node.relpath+"ftv2mnode.png";
      }
      node.expanded = true;
      var n = node.children[o.breadcrumbs[index]];
      if (index+1<o.breadcrumbs.length) {
        showNode(o,n,index+1,hash);
      } else {
        if (typeof(n.childrenData)==='string') {
          var varName = n.childrenData;
          getScript(n.relpath+varName,function(){
            n.childrenData = getData(varName);
            node.expanded=false;
            showNode(o,node,index,hash); // retry with child node expanded
          },true);
        } else {
          var rootBase = stripPath(o.toroot.replace(/\..+$/, ''));
          if (rootBase=="index" || rootBase=="pages" || rootBase=="search") {
            expandNode(o, n, true, true);
          }
          selectAndHighlight(hash,n);
        }
      }
    }
  } else {
    selectAndHighlight(hash);
  }
}

function removeToInsertLater(element) {
  var parentNode = element.parentNode;
  var nextSibling = element.nextSibling;
  parentNode.removeChild(element);
  return function() {
    if (nextSibling) {
      parentNode.insertBefore(element, nextSibling);
    } else {
      parentNode.appendChild(element);
    }
  };
}

function getNode(o, po)
{
  var insertFunction = removeToInsertLater(po.li);
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
      i==l);
  }
  insertFunction();
}

function gotoNode(o,subIndex,root,hash,relpath)
{
  var nti = navTreeSubIndices[subIndex][root+hash];
  o.breadcrumbs = $.extend(true, [], nti ? nti : navTreeSubIndices[subIndex][root]);
  if (!o.breadcrumbs && root!=NAVTREE[0][1]) { // fallback: show index
    navTo(o,NAVTREE[0][1],"",relpath);
    $('.item').removeClass('selected');
    $('.item').removeAttr('id');
  }
  if (o.breadcrumbs) {
    o.breadcrumbs.unshift(0); // add 0 for root node
    showNode(o, o.node, 0, hash);
  }
}

function navTo(o,root,hash,relpath)
{
  var link = cachedLink();
  if (link) {
    var parts = link.split('#');
    root = parts[0];
    if (parts.length>1) hash = '#'+parts[1].replace(/[^\w\-]/g,'');
    else hash='';
  }
  if (hash.match(/^#l\d+$/)) {
    var anchor=$('a[name='+hash.substring(1)+']');
    glowEffect(anchor.parent(),1000); // line number
    hash=''; // strip line number anchors
  }
  var url=root+hash;
  var i=-1;
  while (NAVTREEINDEX[i+1]<=url) i++;
  if (i==-1) { i=0; root=NAVTREE[0][1]; } // fallback: show index
  if (navTreeSubIndices[i]) {
    gotoNode(o,i,root,hash,relpath)
  } else {
    getScript(relpath+'navtreeindex'+i,function(){
      navTreeSubIndices[i] = eval('NAVTREEINDEX'+i);
      if (navTreeSubIndices[i]) {
        gotoNode(o,i,root,hash,relpath);
      }
    },true);
  }
}

function showSyncOff(n,relpath)
{
    n.html('<img src="'+relpath+'sync_off.png" title="'+SYNCOFFMSG+'"/>');
}

function showSyncOn(n,relpath)
{
    n.html('<img src="'+relpath+'sync_on.png" title="'+SYNCONMSG+'"/>');
}

function toggleSyncButton(relpath)
{
  var navSync = $('#nav-sync');
  if (navSync.hasClass('sync')) {
    navSync.removeClass('sync');
    showSyncOff(navSync,relpath);
    storeLink(stripPath2(pathName())+hashUrl());
  } else {
    navSync.addClass('sync');
    showSyncOn(navSync,relpath);
    deleteLink();
  }
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;
  o.node.expanded = false;
  o.node.isLast = true;
  o.node.plus_img = document.createElement("img");
  o.node.plus_img.src = relpath+"ftv2pnode.png";
  o.node.plus_img.width = 16;
  o.node.plus_img.height = 22;

  if (localStorageSupported()) {
    var navSync = $('#nav-sync');
    if (cachedLink()) {
      showSyncOff(navSync,relpath);
      navSync.removeClass('sync');
    } else {
      showSyncOn(navSync,relpath);
    }
    navSync.click(function(){ toggleSyncButton(relpath); });
  }

  $(window).load(function(){
    navTo(o,toroot,hashUrl(),relpath);
    showRoot();
  });

  $(window).bind('hashchange', function(){
     if (window.location.hash && window.location.hash.length>1){
       var a;
       if ($(location).attr('hash')){
         var clslink=stripPath(pathName())+':'+hashValue();
         a=$('.item a[class$="'+clslink.replace(/</g,'\\3c ')+'"]');
       }
       if (a==null || !$(a).parent().parent().hasClass('selected')){
         $('.item').removeClass('selected');
         $('.item').removeAttr('id');
       }
       var link=stripPath2(pathName());
       navTo(o,link,hashUrl(),relpath);
     } else if (!animationInProgress) {
       $('#doc-content').scrollTop(0);
       $('.item').removeClass('selected');
       $('.item').removeAttr('id');
       navTo(o,toroot,hashUrl(),relpath);
     }
  })
}

