/*
             LUFA Library
     Copyright (C) Dean Camera, 2014.

  dean [at] fourwalledcubicle [dot] com
           www.lufa-lib.org
*/

/*
  Copyright 2014  Dean Camera (dean [at] fourwalledcubicle [dot] com)

  Permission to use, copy, modify, distribute, and sell this
  software and its documentation for any purpose is hereby granted
  without fee, provided that the above copyright notice appear in
  all copies and that both that the copyright notice and this
  permission notice and warranty disclaimer appear in supporting
  documentation, and that the name of the author not be used in
  advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.

  The author disclaims all warranties with regard to this
  software, including all implied warranties of merchantability
  and fitness.  In no event shall the author be liable for any
  special, indirect or consequential damages or any damages
  whatsoever resulting from loss of use, data or profits, whether
  in an action of contract, negligence or other tortious action,
  arising out of or in connection with the use or performance of
  this software.
*/

/** \file
 *  \brief LUFA Custom Board LED Hardware Driver (Template)
 *
 *  This is a stub driver header file, for implementing custom board
 *  layout hardware with compatible LUFA board specific drivers. If
 *  the library is configured to use the BOARD_USER board mode, this
 *  driver file should be completed and copied into the "/Board/" folder
 *  inside the application's folder.
 *
 *  This stub is for the board-specific component of the LUFA LEDs driver,
 *  for the LEDs (up to four) mounted on most development boards.
*/

#ifndef __LEDS_USER_H__
#define __LEDS_USER_H__

/* Includes: */
// TODO: Add any required includes here

/* Enable C linkage for C++ Compilers: */
#if defined(__cplusplus)
extern "C" {
#endif

/* Preprocessor Checks: */
#if !defined(__INCLUDE_FROM_LEDS_H)
#error Do not include this file directly. Include LUFA/Drivers/Board/LEDS.h instead.
#endif

/* Public Interface - May be used in end-application: */
/* Macros: */
/** LED mask for the first LED on the board. */
#define LEDS_LED1        (1 << 0)
#define LEDS_LED2        (1 << 1)
#define LEDS_LED3        (1 << 2)
#define LEDS_LED4        (1 << 3)
#define LEDS_LED5        (1 << 4)
#define LEDS_LED6        (1 << 5)
#define LEDS_LED7        (1 << 6)
#define LEDS_LED8        (1 << 7)
// #define LEDS_LED9        (1 << 8)
// #define LEDS_LED10       (1 << 9)
// #define LEDS_LED11       (1 << 10)
// #define LEDS_LED12       (1 << 11)
// #define LEDS_LED13       (1 << 12)
// #define LEDS_LED14       (1 << 13)
// #define LEDS_LED15       (1 << 14)
// #define LEDS_LED16       (1 << 15)


/** LED mask for all the LEDs on the board. */
#define LEDS_ALL_LEDS    (0xFF)

/** LED mask for none of the board LEDs. */
#define LEDS_NO_LEDS     0

/* Inline Functions: */
#if !defined(__DOXYGEN__)
static inline void LEDs_Init(void)
{
	BSP_RegisterWrite(BSP_LED_PORT, 0);
}

static inline void LEDs_Disable(void)
{
	// TODO: Clear the LED port pins as high impedance inputs here
}

static inline void LEDs_TurnOnLEDs(const uint8_t LEDMask)
{
	uint32_t tmp;
	tmp = BSP_RegisterRead(BSP_LED_PORT) & LEDS_ALL_LEDS;
	tmp |= LEDMask;
	BSP_RegisterWrite(BSP_LED_PORT, tmp);
}

static inline void LEDs_TurnOffLEDs(const uint8_t LEDMask)
{
	uint32_t tmp;
	tmp = BSP_RegisterRead(BSP_LED_PORT) & LEDS_ALL_LEDS;
	tmp &= ~LEDMask;
	BSP_RegisterWrite(BSP_LED_PORT, tmp);

}

static inline void LEDs_SetAllLEDs(const uint8_t LEDMask)
{
	BSP_RegisterWrite(BSP_LED_PORT, LEDMask & LEDS_ALL_LEDS);
}

static inline void LEDs_ChangeLEDs(const uint8_t LEDMask, const uint8_t ActiveMask)
{
  (void)LEDMask;
  (void)ActiveMask;
  // TODO: Add code to set the Leds in the given LEDMask to the status given in ActiveMask here
}

static inline void LEDs_ToggleLEDs(const uint8_t LEDMask)
{
	uint32_t tmp;
	tmp = BSP_RegisterRead(BSP_LED_PORT) & LEDS_ALL_LEDS;
	tmp ^= LEDMask;
	BSP_RegisterWrite(BSP_LED_PORT, tmp);
}

static inline uint8_t LEDs_GetLEDs(void) ATTR_WARN_UNUSED_RESULT;
static inline uint8_t LEDs_GetLEDs(void)
{
	return (BSP_RegisterRead(BSP_LED_PORT) & LEDS_ALL_LEDS);
}
#endif

/* Disable C linkage for C++ Compilers: */
#if defined(__cplusplus)
}
#endif

#endif

