/***************************************************************************//**
 * @file
 * @brief Provide configuration parameters for EM4 wakeup button.
 * @version 4.1.0
 *******************************************************************************
 * @section License
 * <b>(C) Copyright 2014 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef __SILICON_LABS_EM4CONFIG_H__
#define __SILICON_LABS_EM4CONFIG_H__

#include "bspconfig.h"

#define PB1_SW_IRQ            PB1
#define PB1_SW_IRQ_EN        (1 << 17) /* GPIO_EM4WU1 = PF7 = pushbutton 1 */
#define PB1_SW_IRQ_PIN       BSP_GPIO_PB1_PIN
#define PB1_SW_IRQ_PORT      BSP_GPIO_PB1_PORT
#define PB1_SW_IRQ_STR       "PB1"

#define PB0_SW_IRQ          PB0
#define PB0_SW_IRQ_PIN      BSP_GPIO_PB0_PIN
#define PB0_SW_IRQ_PORT     BSP_GPIO_PB0_PORT
#define PB0_SW_IRQ_STR      "PB0"

#endif /* __SILICON_LABS_EM4CONFIG_H__ */
