/**************************************************************************//**
 * @file  lcddisplay.h
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef __LCDDISPLAY_H__
#define __LCDDISPLAY_H__

#include "progconfig.h"

#if (USE_EFM32_STK == TRUE)
#define LCD_SPI_USART   USART1
#define LCD_SPI_CMU     cmuClock_USART1   
#define LCD_SPI_TXPORT  gpioPortD
#define LCD_SPI_TXPIN   0
#define LCD_SPI_RXPORT  gpioPortD
#define LCD_SPI_RXPIN   1
#define LCD_SPI_CLKPORT gpioPortD
#define LCD_SPI_CLKPIN  2
#define LCD_SPI_CS_PORT gpioPortD
#define LCD_SPI_CS_PIN  6
#define LCD_SPI_LOC     USART_ROUTE_LOCATION_LOC1
#define LCD_RESET_PORT  gpioPortB
#define LCD_RESET_PIN   12

/* Marco for CS and RESET pin */
#define LCD_CS_CLR()    GPIO->P[3].DOUTCLR = 0x0040
#define LCD_CS_SET()    GPIO->P[3].DOUTSET = 0x0040
#define LCD_RESET_CLR() GPIO->P[1].DOUTCLR = 0x1000
#define LCD_RESET_SET() GPIO->P[1].DOUTSET = 0x1000

#if (EXTERNAL_MEMORY == SPI_NOR_FLASH) && (DISP_INTERFACE == DISP_EXT_LCD)
/* Use one USART for SPI LCD and Flash */
#define SHARE_SPI       1
#else
#define SHARE_SPI       0
#endif

#else
#define LCD_SPI_USART   USART0
#define LCD_SPI_CMU     cmuClock_USART0   
#define LCD_SPI_TXPORT  gpioPortE
#define LCD_SPI_TXPIN   10
#define LCD_SPI_RXPORT  gpioPortE
#define LCD_SPI_RXPIN   11
#define LCD_SPI_CLKPORT gpioPortE
#define LCD_SPI_CLKPIN  12
#define LCD_SPI_CS_PORT gpioPortE
#define LCD_SPI_CS_PIN  13
#define LCD_SPI_LOC     USART_ROUTE_LOCATION_LOC0
#define LCD_RESET_PORT  gpioPortE
#define LCD_RESET_PIN   9

/* Marco for CS and RESET pin */
#define LCD_CS_CLR()    GPIO->P[4].DOUTCLR = 0x2000
#define LCD_CS_SET()    GPIO->P[4].DOUTSET = 0x2000
#define LCD_RESET_CLR() GPIO->P[4].DOUTCLR = 0x0200
#define LCD_RESET_SET() GPIO->P[4].DOUTSET = 0x0200

#define SHARE_SPI       0
#endif

#define LCD_SPI_FREQ    4000000

#define INS_START       0x1f
#define DATA_START      0x5f
#define READ_START      0x3f
#define READ_BUSY       0x0
#define BUSY_MASK       0x80

#define ROW_MAX         4   
#define COL_MAX         20   
#define SET_ROW1        0xa0
#define SET_ROW2        0xc0
#define SET_ROW3        0xe0
#define DISP_CLEAR      0x01
#define DATA_SPACE      0x20

#if defined(__CROSSWORKS_ARM)
int __putchar(int ch);
int __getchar(void);
#endif

int RETARGET_ReadChar(void);
int RETARGET_WriteChar(char c);

void initLcdDisp(void);

#endif
