/**************************************************************************//**
 * @file  main.c
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#include <stdbool.h>
#include "em_device.h"
#include "kits.h"
#include "delay.h"
#include "menuutil.h"
#include "progconfig.h"
#include "usbtomemory.h"
#if (DISP_INTERFACE == DISP_EXT_LCD)
#include "lcddisplay.h"
#elif (DISP_INTERFACE == DISP_VCOM)
#include "vcomdisplay.h"
#endif
#if (EXTERNAL_MEMORY == EBI_NAND_FLASH)
#include "nandflash.h"
#include "nandutil.h"
#else
#include "spiflash.h"
#endif

/**************************************************************************//**
 * @brief main - the entrypoint after reset.
 *****************************************************************************/
int main( void )
{
  /* Setup kit */
  initKit();

  /* Setup TIMER and RTC for delay functions */
  initDelay();

  /* Init external memory */
#if (EXTERNAL_MEMORY == EBI_NAND_FLASH)
  initNandFlash();
#else
  initSpiFlash();
#endif

  /* Init display interface */
#if (DISP_INTERFACE == DISP_EXT_LCD)
  initLcdDisp();
#elif (DISP_INTERFACE == DISP_VCOM)
  RETARGET_SerialInit();
#endif
  
  /* Init USB and start */
  initUsbHost();
  menuSelect();
}
