/**************************************************************************//**
 * @file  nandutil.h
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef __NANDUTIL_H__
#define __NANDUTIL_H__

/* Buffer size for NAND flash page and block */
#define NAND_FLASH_PAGE_SIZE            512     /* 512 B */     
#define NAND_FLASH_BLOCK_SIZE           16384   /* 16 KB */
#define NAND_FLASH_PAGE_SIZE_MASK       0x1FF     

#define PAGENUM_2_ADDR(x)  ( ( (x) * NANDFLASH_DeviceInfo()->pageSize ) + \
                               NANDFLASH_DeviceInfo()->baseAddress )
#define BLOCKNUM_2_ADDR(x) ( ( (x) * NANDFLASH_DeviceInfo()->blockSize ) + \
                               NANDFLASH_DeviceInfo()->baseAddress )
#define ADDR_2_PAGENUM(x)  ( ( (x) - NANDFLASH_DeviceInfo()->baseAddress ) / \
                             NANDFLASH_DeviceInfo()->pageSize)
#define ADDR_2_BLOCKNUM(x) ( ( (x) - NANDFLASH_DeviceInfo()->baseAddress ) / \
                             NANDFLASH_DeviceInfo()->blockSize)

void initNandFlash(void);
void nandFlashEraseBlock(uint32_t blockNum);
void nandFlashReadPage(uint32_t pageNum, uint8_t *buffer);
void nandFlashWritePage(uint32_t pageNum, uint8_t *buffer);

#endif
