/**************************************************************************//**
 * @file  spiflash.h
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef __SPIFLASH_H__
#define __SPIFLASH_H__

#define USE_AUTOTX      0

/* USART for SPI Flash */
#define USART_USED      USART1
#define USART_CMUCLK    cmuClock_USART1   
#define USART_TXPORT    gpioPortD
#define USART_TXPIN     0
#define USART_RXPORT    gpioPortD
#define USART_RXPIN     1
#define USART_CLKPORT   gpioPortD
#define USART_CLKPIN    2
#define USART_CS_PORT   gpioPortD
#define USART_CS_PIN    3
#define USART_LOCATION  USART_ROUTE_LOCATION_LOC1

/* Marco for CS pin */
#define FLASH_CS_CLR()  GPIO->P[3].DOUTCLR = 0x0008
#define FLASH_CS_SET()  GPIO->P[3].DOUTSET = 0x0008

/* SPI Flash command */
#define WRITE           0x02    /* Write to Memory command (page program) */
#define WREN            0x06    /* Write enable command */
#define READ            0x03    /* Read from Memory command */
#define RDSR            0x05    /* Read Status Register command  */
#define RDID            0x9F    /* Read ID command */
#define SERASE          0x20    /* Sector Erase command */
#define BERASE          0xD8    /* Block Erase command */
#define CERASE          0xC7    /* Chip Erase command */

/* SPI Flash status flag */
#define WIP             0x01    /* Write In Progress (WIP) flag */

/* SPI Flash memory organization, setting for 4 MB flash with 4 KB sector erase */
#define SPIF_PAGESIZE           256     /* 256 byte (0x100) */
#define SPIF_SECTORSIZE         4096    /* 4 KB (0x1000) */
#define SPIF_BLOCKSIZE          65536   /* 64 KB (0x10000) */
#define SPIF_DEVICESIZE         4194304 /* 4 MB (0x400000) */        
#define SPIF_PAGESIZE_MASK      0xFF     

void initSpiFlash(void);
uint32_t spiFlashReadId(void);
void spiFlashSectorBlockErase(uint8_t eraseMode, uint32_t sectorBlockAddr);
void spiFlashChipErase(void);
void spiFlashPageWrite(uint8_t* writeBuffer, uint32_t startWriteAddr, uint16_t numOfWrite);
void spiFlashSectorWrite(uint8_t* writeBuffer, uint32_t startWriteAddr);
void spiFlashBufferWrite(uint8_t* writeBuffer, uint32_t startWriteAddr, uint16_t numOfWrite);
void spiFlashSetReadAddr(uint32_t startReadAddr);
void spiFlashBufferRead(uint8_t* readBuffer, uint32_t startReadAddr, uint16_t numOfRead);

#endif
