/**************************************************************************//**
 * @file  usbtomemory.h
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef __USBTOMEMORY_H__
#define __USBTOMEMORY_H__

#include "ff.h"
#include "progconfig.h"

#define INFO_SIZE               32
#define BUFFER_OFFSET           32
#define FILE_NAME_SIZE          16
#define DEVICE_NAME_SIZE        20
#define ADDRESS_LENGTH          8
#define NAME_INDEX_MAX          9

#if (EXTERNAL_MEMORY == EBI_NAND_FLASH)
/* NAND flash */
/* Address to store main flash binary */
#define MAIN_DATA_ADDR_BLOCK    0
#define MAIN_DATA_ADDR_PAGE     0
/* Address to store user page binary */
#define USER_DATA_ADDR_BLOCK    2043
#define USER_DATA_ADDR_PAGE     USER_DATA_ADDR_BLOCK*32
/* Address to store main flash program information */
#define MAIN_INFO_ADDR_BLOCK    2044
#define MAIN_INFO_ADDR_PAGE     MAIN_INFO_ADDR_BLOCK*32
#define MAIN_FILE_ADDR_BLOCK    2045
#define MAIN_FILE_ADDR_PAGE     MAIN_FILE_ADDR_BLOCK*32
/* Address to store user page program information */
#define USER_INFO_ADDR_BLOCK    2046
#define USER_INFO_ADDR_PAGE     USER_INFO_ADDR_BLOCK*32
#define USER_FILE_ADDR_BLOCK    2047
#define USER_FILE_ADDR_PAGE     USER_FILE_ADDR_BLOCK*32
#else
/* SPI flash */
/* Address to store main flash binary */
#define MAIN_DATA_SECTOR        0
#define MAIN_DATA_PAGE          0
/* Address to store user page binary */
#define USER_DATA_SECTOR        0x003FD000
#define USER_DATA_PAGE          0x003FD000
/* Address to store main flash program information */
#define MAIN_INFO_ADDR          0x003FF000
#define MAIN_INFO_SIZE          32
#define MAIN_FILE_ADDR          0x003FF400
#define MAIN_FILE_SIZE          32
/* Address to store user page program information */
#define USER_INFO_ADDR          0x003FF800
#define USER_INFO_SIZE          32 
#define USER_FILE_ADDR          0x003FFC00
#define USER_FILE_SIZE          32
#endif

#define MIN_PAGE_SIZE           256
#define INT_PAGE_MASK           0x00000fff
#define INT_START_ADDR          512*1024
#define MSC_RWDOUBLE            0x25
#define MSC_ERASEUPPER          0x0200
#define USER_PAGE_ADDR          0x0fe00000

bool getBinInfoFromExtMem(void);
bool uploadImageFromUsb(void);
void initUsbHost(void);
DWORD get_fattime( void );

#endif
