/**************************************************************************//**
 * @file  menuutil.h
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef __MENUUTIL_H__
#define __MENUUTIL_H__

#include <stdio.h>
#include "progconfig.h"

#define PROG_MENU               0
#define UPLOAD_MENU             1
#define ERASE_MAIN_MENU         2
#define ERASE_USER_MENU         3
#define PROG_SUB_MENU           8
#define UPLOAD_SUB_MENU         9
#define ERASE_MAIN_SUB_MENU     10
#define ERASE_USER_SUB_MENU     11
#define SUB_MENU_MASK           0x08

__STATIC_INLINE void menuRow0(void)
{
#if (DISP_INTERFACE == DISP_EXT_LCD)
  printf(" Program Flash  PB0%c\n", 0xe0);
#else
  printf(" Program Flash\n");
#endif
}

__STATIC_INLINE void menuRow1(void)
{
#if (DISP_INTERFACE == DISP_EXT_LCD)
  printf(" Upload Image   PB1%c\n", 0x1c);
#else
  printf(" Upload Image\n");
#endif
}
        
__STATIC_INLINE void menuRow2(void)
{
  printf(" Erase Main Flash\n");
}

__STATIC_INLINE void menuRow3(void)
{
  printf(" Erase User Page\n");
}

__STATIC_INLINE void menuRow0Sel(void)
{
#if (DISP_INTERFACE == DISP_EXT_LCD)
  printf("%cProgram Flash  PB0%c\n", 0x10, 0xe0);
#else
  printf(">Program Flash\n");
  setErrorLed(false);
  setBusyLed(false);
#endif
}

__STATIC_INLINE void menuRow1Sel(void)
{
#if (DISP_INTERFACE == DISP_EXT_LCD)
  printf("%cUpload Image   PB1%c\n", 0x10, 0x1c);
#else
  printf(">Upload Image\n");
  setErrorLed(true);
  setBusyLed(false);
#endif
}
        
__STATIC_INLINE void menuRow2Sel(void)
{
#if (DISP_INTERFACE == DISP_EXT_LCD)
  printf("%cErase Main Flash\n", 0x10);
#else
  printf(">Erase Main Flash\n");
  setErrorLed(false);
  setBusyLed(true);
#endif
}

__STATIC_INLINE void menuRow3Sel(void)
{
#if (DISP_INTERFACE == DISP_EXT_LCD)
  printf("%cErase User Page\n", 0x10);
#else
  printf(">Erase User Page\n");
  setErrorLed(true);
  setBusyLed(true);
#endif
}

void menuSelect(void);

#endif
