/**************************************************************************//**
 * @file  progconfig.h
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef __PROGCONFIG_H__
#define __PROGCONFIG_H__

#define TRUE                    1
#define FALSE                   0

/* Use EFM32GG/WG STK as standalone programmer, 0 - customize board, 1 - STK */
#define USE_EFM32_STK           TRUE

/* Text file name with program information */
#define TEXT_FILENAME           "proginfo.txt"

/* External memory to store binary file, 0 - SPI NOR flash, 1 - EBI NAND flash */
#define SPI_NOR_FLASH           0
#define EBI_NAND_FLASH          1
#define EXTERNAL_MEMORY         EBI_NAND_FLASH

/* Timeout in second for USB flash drive plug-in */
#define USB_WAIT_TIMEOUT        5

/* Skip polling flash write ready, 1 to skip */
#define SKIP_POLLING            TRUE

/* Delay in us after flash write, different value for EFM32GG and EFM32WG */
#if (SKIP_POLLING == TRUE)
#if defined(_EFM32_GIANT_FAMILY)
#define WRITE_DELAY             10
#else
#define WRITE_DELAY             11
#endif
#endif

/* Pin reset delay in ms after debug lock */
#define LOCK_RESET_DELAY        1

/* Dealy in ms for flash erase */
#define ERASE_DELAY             20

/* Timeout count for flase erase */
#define ERASE_LOOPCNT           400

/* Pin reset pulse width in ms */
#define RESET_PULSE_WIDTH       1

/* Delay in ms after pin reset */
#define RESET_DELAY             1

/* Delay in ms after swithcing MUX control pins */
#define MUX_DELAY               1

/* Display interface, 0 - None, 1 - External LCD and 2 - VCOM */
#define DISP_NONE               0
#define DISP_EXT_LCD            1
#define DISP_VCOM               2
#define DISP_INTERFACE          DISP_VCOM

#if (DISP_INTERFACE == DISP_NONE)
#define printf(...)
#define displayClear()
#define setLcdRow1()
#define setLcdRow2()
#define setLcdRow3()
#elif (DISP_INTERFACE == DISP_EXT_LCD)
#define displayClear()  printf("\a")
#define setLcdRow1()    printf("\b")
#define setLcdRow2()    printf("\t")
#define setLcdRow3()    printf("\v")
#elif (DISP_INTERFACE == DISP_VCOM)
#define displayClear()
#define setLcdRow1()
#define setLcdRow2()
#define setLcdRow3()
#else
#error "Undefined display interface."
#endif

#endif
