/**************************************************************************//**
 * @file  delay.c
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#include "em_device.h"
#include "em_timer.h"
#include "em_cmu.h"

#define RTC_FREQ 32768
#define TIMER_FREQ 48000000


/**********************************************************
 * Enables clocks used for delay functions.
 **********************************************************/
void initDelay(void)
{
  CMU_ClockEnable(cmuClock_CORELE, true);
  CMU_ClockSelectSet(cmuClock_LFA, cmuSelect_LFRCO);
  CMU_ClockEnable(cmuClock_RTC, true);
  CMU_ClockEnable(cmuClock_TIMER1, true);
}


/**********************************************************
 * Delay a number of milliseconds
 **********************************************************/
void delayMs(int ms)
{
  uint32_t endValue = ms * RTC_FREQ / 1000;
  RTC->CNT = 0;
  
  RTC->CTRL |= RTC_CTRL_EN;
  
  while ( RTC->CNT < endValue );
  
  RTC->CTRL &= ~RTC_CTRL_EN;
}


/**********************************************************
 * Delay a number of microseconds
 **********************************************************/
void delayUs(int us)
{
  uint32_t endValue = us * (TIMER_FREQ / 1000000);
  TIMER1->CNT = 0;

  TIMER1->CMD = TIMER_CMD_START;
  
  while ( TIMER1->CNT < endValue );
  
  TIMER1->CMD = TIMER_CMD_STOP;
}
