/**************************************************************************//**
 * @file  errors.h
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef _ERROR_H_
#define _ERROR_H_

#include <setjmp.h>

#define SWD_ERROR_OK                    1
#define SWD_ERROR_WAIT                  2
#define SWD_ERROR_FAULT                 3
#define SWD_ERROR_PROTOCOL              4
#define SWD_ERROR_PARITY                5
#define SWD_ERROR_MCU_LOCKED            6
#define SWD_ERROR_INVALID_IDR           7
#define SWD_ERROR_INVALID_IDCODE        8
#define SWD_ERROR_FLASH_WRITE_FAILED    9
#define SWD_ERROR_UNLOCK_FAILED         10
#define SWD_ERROR_AAP_EXTENSION_FAILED  11
#define SWD_ERROR_LOCK_FAILED           12
#define SWD_ERROR_CLR_DLW_FAILED        13
#define SWD_ERROR_MASS_ERASE_TIMEOUT    14
#define SWD_ERROR_VERIFY_FW_FAILED      15
#define SWD_ERROR_TIMEOUT_WAITING_RESET 16
#define SWD_ERROR_TARGET_NOT_HALTED     17
#define SWD_ERROR_FLASHLOADER_ERROR     18
#define SWD_ERROR_DEVICE_ERASE_FAILED   19
#define SWD_ERROR_TIMEOUT_HALT          20
#define SWD_ERROR_DEBUG_POWER           21

char *getErrorString(int errorCode);

/* Maximum number of nested TRY/CATCH blocks */
#define EXCEPTION_MAX_LEVEL 5

extern jmp_buf swdErrors[];
extern int swdErrorIndex;

/* Raise an error */
#define RAISE(x) longjmp(swdErrors[swdErrorIndex], x)

/* During debugging this macro can be used instead to generate a 
 * breakpoint at the point where an error occurs */
//#define RAISE(x) __asm("bkpt 1");

/* Start TRY/CATCH block */
#define TRY { int errorCode = setjmp(swdErrors[++swdErrorIndex]); \
  if ( errorCode == 0 ) { 

/* Start CATCH clause */
#define CATCH } else {
    
/* End TRY/CATCH block */
#define ENDTRY } swdErrorIndex--;}

#endif
