/**************************************************************************//**
 * @file  flash_write.h
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef _FLASH_WRITE_H_
#define _FLASH_WRITE_H_

void eraseUserPage(void);
void erasePages(uint32_t startAddr, uint32_t size);
void writeWordToFlash(uint32_t addr, uint32_t data);
void flashMainWithMsc(uint32_t startAddr, uint32_t binFileSize);
void flashUserWithMsc(uint32_t binFileSize);
void flashMainUserWithMsc(uint32_t startAddr, uint32_t mainBinSize, uint32_t userBinSize);

#endif
