/**************************************************************************//**
 * @file  kits.h
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef _KITS_H_
#define _KITS_H_

#include "progconfig.h"

#if (USE_EFM32_STK == TRUE)
/* Push buttons and LEDs used */
#define GPIO_KEY0_PORT  gpioPortB
#define GPIO_KEY0_PIN   9
#define GPIO_KEY1_PORT  gpioPortB
#define GPIO_KEY1_PIN   10

#define GPIO_LED0_PORT  gpioPortE
#define GPIO_LED0_PIN   2
#define GPIO_LED1_PORT  gpioPortE
#define GPIO_LED1_PIN   3

/* MUX control pins */
#define MUX_CTRLA_PORT  gpioPortB
#define MUX_CTRLA_PIN   11
#define MUX_CTRLB_PORT  gpioPortD
#define MUX_CTRLB_PIN   7
#define MUX_CTRLC_PORT  gpioPortD
#define MUX_CTRLC_PIN   3
#define MUX_OE_PORT     gpioPortD
#define MUX_OE_PIN      5

#define GANG4_PORT      gpioPortB
#define GANG4_PIN       9
#define GANG8_PORT      gpioPortB
#define GANG8_PIN       10

/* SWCLK & SWDIO must on same GPIO port and RESET is NOT connected to this port */
#define SWCLK_PORT      2
#define SWCLK_PIN       4
#define SWDIO_PORT      2
#define SWDIO_PIN       5
#define RESET_PORT      3
#define RESET_PIN       4
#else
/* Push buttons and LEDs used */
#define GPIO_KEY0_PORT  gpioPortC
#define GPIO_KEY0_PIN   8
#define GPIO_KEY1_PORT  gpioPortC
#define GPIO_KEY1_PIN   9

#define GPIO_LED0_PORT  gpioPortE
#define GPIO_LED0_PIN   14
#define GPIO_LED1_PORT  gpioPortE
#define GPIO_LED1_PIN   15

/* MUX control pins */
#define MUX_CTRLA_PORT  gpioPortD
#define MUX_CTRLA_PIN   5
#define MUX_CTRLB_PORT  gpioPortD
#define MUX_CTRLB_PIN   6
#define MUX_CTRLC_PORT  gpioPortD
#define MUX_CTRLC_PIN   7
#define MUX_OE_PORT     gpioPortD
#define MUX_OE_PIN      8

#define GANG4_PORT      gpioPortC
#define GANG4_PIN       6
#define GANG8_PORT      gpioPortC
#define GANG8_PIN       7

/* SWCLK & SWDIO must on same GPIO port and RESET is NOT connected to this port */
#define SWCLK_PORT      0
#define SWCLK_PIN       4
#define SWDIO_PORT      0
#define SWDIO_PIN       5
#define RESET_PORT      2
#define RESET_PIN       4
#endif

void setBusyLed(bool on);
void setErrorLed(bool on);
void initKit(void);

#endif
