/**************************************************************************//**
 * @file  vcomdisplay.c
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#include <stdio.h>
#include "em_device.h"
#include "em_cmu.h"
#include "em_gpio.h"
#include "em_usart.h"
#include "progconfig.h"
#include "vcomdisplay.h"


#if (DISP_INTERFACE == DISP_VCOM)
/**************************************************************************//**
 * @brief Intializes UART/LEUART
 *****************************************************************************/
void RETARGET_SerialInit(void)
{
  USART_InitAsync_TypeDef init = USART_INITASYNC_DEFAULT;

  /* Enable peripheral clocks */
  CMU_ClockEnable(RETARGET_CLK, true);

  /* Configure USART for basic async operation */
  init.enable = usartEnableTx;
  USART_InitAsync(RETARGET_UART, &init);

  /* Enable STK virtual COM part */
  RETARGET_ENABLE();
  
  /* To avoid false start, configure output as high */
  GPIO_PinModeSet(RETARGET_TXPORT, RETARGET_TXPIN, gpioModePushPull, 1);

  /* Enable pins at correct UART/USART location. */
  RETARGET_UART->ROUTE = USART_ROUTE_TXPEN | RETARGET_LOCATION;

#if !defined(__CROSSWORKS_ARM) && defined(__GNUC__)
  setvbuf(stdout, NULL, _IONBF, 0);   /*Set unbuffered mode for stdout (newlib)*/
#endif
}


/**************************************************************************//**
 * @brief Receive a byte
 *    No input method from UART, thus we always return -1
 *
 * @return -1 on failure
 *****************************************************************************/
int RETARGET_ReadChar(void)
{
  return -1;
}


/**************************************************************************//**
 * @brief Transmit single byte to USART/LEUART
 * @param c Character to transmit
 * @return Transmitted character
 *****************************************************************************/
int RETARGET_WriteChar(char c)
{
  /* Add CR or LF to CRLF if enabled */
  if (c == '\n')
  {
    RETARGET_TX(RETARGET_UART, '\r');
  }
  RETARGET_TX(RETARGET_UART, c);

  if (c == '\r')
  {
    RETARGET_TX(RETARGET_UART, '\n');
  }

  return c;
}
#endif
