/**************************************************************************//**
 * @file  vcomdisplay.h
 * @brief EFM32 standalone programmer.
 * @version 0.10
 ******************************************************************************
 * @section License
 * <b>(C) Copyright 2016 Silicon Labs, http://www.silabs.com</b>
 *******************************************************************************
 *
 * This file is licensed under the Silabs License Agreement. See the file
 * "Silabs_License_Agreement.txt" for details. Before using this software for
 * any purpose, you must agree to the terms of that agreement.
 *
 ******************************************************************************/

#ifndef __VCOMDISPLAY_H
#define __VCOMDISPLAY_H

#include "progconfig.h"

/*                      VCOM ENABLE     UART    TX      LOCATION        */
/* GG/LG/WG STK         PF7             UART0   PE0     1               */
/* GG/LG/WG Board       NA              USART2  PC2     0               */

#if (USE_EFM32_STK == TRUE)
#define RETARGET_CLK            cmuClock_UART0                  /* HFPER Clock */
#define RETARGET_UART           UART0                           /* USART instance */
#define RETARGET_TX             USART_Tx                        /* Set TX to USART_Tx */
#define RETARGET_LOCATION       UART_ROUTE_LOCATION_LOC1        /* Location of of the USART I/O pins */
#define RETARGET_TXPORT         gpioPortE                       /* USART transmission port */
#define RETARGET_TXPIN          0                               /* USART transmission pin */
#define RETARGET_ENPORT         gpioPortF                       /* USART transmission port */
#define RETARGET_ENPIN          7                              /* USART transmission pin */
#define RETARGET_ENABLE()       GPIO_PinModeSet(RETARGET_ENPORT, RETARGET_ENPIN, gpioModePushPull, 1)
#else
#define RETARGET_CLK            cmuClock_USART2                 /* HFPER Clock */
#define RETARGET_UART           USART2                          /* USART instance */
#define RETARGET_TX             USART_Tx                        /* Set TX to USART_Tx */
#define RETARGET_LOCATION       USART_ROUTE_LOCATION_LOC0       /* Location of of the USART I/O pins */
#define RETARGET_TXPORT         gpioPortC                       /* USART transmission port */
#define RETARGET_TXPIN          2                               /* USART transmission pin */
#define RETARGET_ENABLE()
#endif

#if defined(__CROSSWORKS_ARM)
int __putchar(int ch);
int __getchar(void);
#endif

int  RETARGET_ReadChar(void);
int  RETARGET_WriteChar(char c);
void RETARGET_SerialInit(void);

#endif
