;-----------------------------------------------------------------------------
;	Copyright (C) 2000 CYGNAL INTEGRATED PRODUCTS, INC.
; 	All rights reserved.
;
;
; 	FILE NAME  	: Sram.ASM 
; 	TARGET MCU	: C8051F000
; 	DESCRIPTION	: External Sram read/write verification routine for
;									IDT 71V124SA.    
;
;
;-----------------------------------------------------------------------------
; EQUATES
;-----------------------------------------------------------------------------

$NOLIST
$MOD8F000
$LIST






;---------------------------------------
; Constants and Declarations
;---------------------------------------

DATA1		EQU	P3				; port for DATA pins(AD7..0)
DATACF	EQU	PRT3CF		; port configuration register for DATA
ADDR		EQU	P2				; port for ADDR pins(A15..8)
ADDRCF	EQU	PRT2CF		; port configuration register for ADDR
A16			EQU	P1.5			; upper address bit(address bank select)
RD			EQU	P1.4			; READ strobe (activelow)
WR			EQU	P1.3			; WRITE strobe (activelow)
ALE			EQU	P1.2			; address latch signal(active low)
CS			EQU	P1.1			; SRAM chip select(active low)




;-----------------------------------------------------------------------------
; VARIABLES
;-----------------------------------------------------------------------------



;-----------------------------------------------------------------------------
; RESET and INTERRUPT VECTORS
;-----------------------------------------------------------------------------
; Reset Vector

		org	00h					
		ljmp	Main


;-----------------------------------------------------------------------------
; MAIN PROGRAM CODE
;-----------------------------------------------------------------------------


				org	0B3h
Main:

				; Disable the WDT. (IRQs not enabled at this point.)
				; if interrupts were enabled, we would need to explicitly disable
				; them so that the following two instructions were guaranteed to
				; to execute within 4 clock cycles of each other.
				mov		WDTCN, #0DEh
				mov		WDTCN, #0ADh
				; Set up the XBar.
				mov	XBR2, #40h			; Weak pull-ups, XBAR enabled.
				lcall		SRAM_Init		; Initialize SRAM


				mov		R0, #0ffh
				mov		DPH, #00h			; initialize 16bit address
				mov		DPL, #00h			;
				mov		a, R0					; load write value

				; Loop will write a value to ram, read it, then verify the value
loop:				
				lcall		SRAM_Write			;write to sram
				clr		a							; clear load value
			  lcall		SRAM_Read		; read same address
				cjne	a, 00h, error
				inc 	dptr					; next address
				mov		a, DPH				; check dptr for finished	
				orl		a, DPL				;
				jz		b1done				; we are finished with the first 64k bank if dptr rolls over				
				mov		a, R0					; reload write value
				jmp		loop					; write; read; and verify again

b1done:		
				orl	P1, #00111010b		;  change to bank 2
				mov		R0, #0ffh
				mov		DPH, #00h			; initialize 16bit address
				mov		DPL, #00h			;
				mov		a, R0					; load write value

				; Loop will write a value to ram, read it, then verify the value
loop1:				
				lcall		SRAM_Write			;write to sram
				clr		a							; clear load value
			  lcall		SRAM_Read		; read same address
				cjne	a, 00h, error
				inc 	dptr					; next address
				mov		a, DPH				; check dptr for finished	
				orl		a, DPL				;
				jz		b2done				; we are finished with the first 64k bank if dptr rolls over				
				mov		a, R0					; reload write value
				jmp		loop1					; write; read; and verify again				
				
			
b2done:	jmp		$							; 
error:	jmp		$							; a verification error has occured



;---------------------------------------
; SRAM_Init
;---------------------------------------
; This routine initializes the SRAM interface logic.  Must be calledonce
; before any SRAM_Read or SRAM_Write operations, typically as part ofthe 
; reset sequence.  This routine assumes that the crossbar has alreadybeen
; enabled (XBR2.6 = '1').
;

SRAM_Init:
	mov	DATACF, #00h		; Enable Port3 (DATA) as aninput bus
	mov	DATA1, #0ffh
	mov	ADDRCF, #0ffh		; Enable Port2 (ADDR) as anoutput
	mov	ADDR, #0ffh			;  driven high ($ff)
	orl	PRT1CF, #00111110b	; enable P1.7..3 as outputs
	anl	P1, #11011011b		;  A16 = '0'; ALE = '0'   bank 1
	orl	P1, #00011010b		;  RD, WR, CS = '1'
	ret



;---------------------------------------
; SRAM_Read
;---------------------------------------
; This routine reads from the external SRAM.  Specifically, it returns
; in ACC the data at the address pointed to by DPTR.  Bank select
; (manipulation of A16) is not handled here.
;
SRAM_Read:
	clr	CS						; select external SRAM
	mov	ADDR, DPH			; force external address A15..A8
	mov	DATACF, #0ffh	; enable AD7..0 as outputs
	mov	DATA1, DPL			; force external address A7..A0
	setb	ALE					; latch the address
	clr	ALE
	mov	DATACF, #00h	; enable AD7..0 as inputs
	mov	DATA1, #0ffh
	clr	RD						; activate READ strobe
	mov	a, DATA1				; read the data (note: setuptime for OE-based
										;  reads is 45ns forthis SRAM.  At SYSCLK
										;  = 20MHz, this movetakes 2 clock cycles, or
										;  50ns * 2 = 100ns.
	setb	RD					; de-assert READ strobe
	setb	CS					; de-select SRAM
	ret

;Totals for a read are:
;30 bytes, 34 cycles.



;---------------------------------------
; SRAM_Write
;---------------------------------------
; This routine writes a byte to the external SRAM.  Specifically, itwrites
; the byte in ACC to the address pointed to by DPTR.  Bank select
; (manipulation of A16) is not handled here.
;
SRAM_Write:
	clr	CS						; select external SRAM
	mov	ADDR, DPH			; force external address A15..A8
	mov	DATACF, #0ffh	; enable AD7..0 as outputs
	mov	DATA1, DPL			; force external address A7..A0
	setb	ALE					; latch the address
	clr	ALE
	mov	DATA1, a				; present the data to the DATA bus
	clr	WR						; activate WRITE strobe
	setb	WR					; de-assert WRITE strobe
										; note: this results in a write pulse width
										;  of 100ns with a 20MHz sysclk.  The minimum
										;  width for this SRAM is 60ns.
	mov	DATACF, #00h	; enable AD7..0 as inputs
	mov	DATA1, #0ffh
	setb	CS					; de-select SRAM
	ret
;-----------------------------------------------------------------------------
; End of file.

END
